/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.composition.helpers;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openrdf.annotations.Iri;
import org.openrdf.repository.object.exceptions.BehaviourException;
import org.openrdf.repository.object.traits.BooleanMessage;
import org.openrdf.repository.object.traits.ByteMessage;
import org.openrdf.repository.object.traits.CharacterMessage;
import org.openrdf.repository.object.traits.DoubleMessage;
import org.openrdf.repository.object.traits.FloatMessage;
import org.openrdf.repository.object.traits.IntegerMessage;
import org.openrdf.repository.object.traits.LongMessage;
import org.openrdf.repository.object.traits.MessageContext;
import org.openrdf.repository.object.traits.ObjectMessage;
import org.openrdf.repository.object.traits.ShortMessage;
import org.openrdf.repository.object.traits.VoidMessage;

public class InvocationMessageContext
implements ObjectMessage {
    private final Object target;
    private final Method method;
    private Object[] parameters;
    private final List<Object> invokeTarget = new ArrayList<Object>();
    private final List<Method> invokeMethod = new ArrayList<Method>();
    private int count;

    public InvocationMessageContext(Object target, Method method, Object[] parameters) {
        this.target = target;
        this.method = method;
        this.parameters = parameters;
    }

    public synchronized InvocationMessageContext appendInvocation(Object target, Method method) {
        this.invokeTarget.add(target);
        this.invokeMethod.add(method);
        return this;
    }

    public synchronized String toString() {
        String params = Arrays.asList(this.parameters).toString();
        String values = params.substring(1, params.length() - 1);
        return this.method.getName() + "(" + values + ")";
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public synchronized Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public synchronized void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public synchronized Object proceed() throws Exception {
        try {
            Class<?> responseType;
            Class<?> resultType;
            Object it;
            Method im;
            Object result;
            do {
                responseType = this.method.getReturnType();
                if (this.count >= this.invokeTarget.size()) {
                    return this.nil(responseType);
                }
                im = this.invokeMethod.get(this.count);
                it = this.invokeTarget.get(this.count);
                ++this.count;
                Class<?>[] param = im.getParameterTypes();
                resultType = im.getReturnType();
                if (param.length != 1 || !MessageContext.class.isAssignableFrom(param[0])) continue;
                result = im.invoke(it, this.returns(resultType));
                return this.cast(result, resultType, responseType);
            } while (this.isNil(result = im.invoke(it, this.getParameters(im)), resultType));
            return this.cast(result, resultType, responseType);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new BehaviourException(cause);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            IllegalAccessError error = new IllegalAccessError(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    private MessageContext returns(Class<?> returnType) {
        if (!returnType.isPrimitive()) {
            return this;
        }
        if (Boolean.TYPE.equals(returnType)) {
            return new BooleanInvocation(this);
        }
        if (Byte.TYPE.equals(returnType)) {
            return new ByteInvocation(this);
        }
        if (Character.TYPE.equals(returnType)) {
            return new CharacterInvocation(this);
        }
        if (Double.TYPE.equals(returnType)) {
            return new DoubleInvocation(this);
        }
        if (Float.TYPE.equals(returnType)) {
            return new FloatInvocation(this);
        }
        if (Integer.TYPE.equals(returnType)) {
            return new IntegerInvocation(this);
        }
        if (Long.TYPE.equals(returnType)) {
            return new LongInvocation(this);
        }
        if (Short.TYPE.equals(returnType)) {
            return new ShortInvocation(this);
        }
        if (Void.TYPE.equals(returnType)) {
            return new VoidInvocation(this);
        }
        throw new AssertionError((Object)("Unknown primitive: " + returnType));
    }

    private Object cast(Object result, Class<?> resultType, Class<?> responseType) {
        if (this.isNil(result, resultType)) {
            return this.nil(responseType);
        }
        if (resultType.equals(responseType) || Object.class.equals(resultType)) {
            return result;
        }
        if (responseType.equals(Set.class)) {
            return Collections.singleton(result);
        }
        if (resultType.equals(Set.class)) {
            Set set = (Set)result;
            if (set.isEmpty()) {
                return this.nil(responseType);
            }
            return set.iterator().next();
        }
        return result;
    }

    private boolean isNil(Object result, Class<?> type) {
        if (result == null) {
            return true;
        }
        if (!type.isPrimitive()) {
            return false;
        }
        return result.equals(this.nil(type));
    }

    private Object nil(Class<?> type) {
        if (Set.class.equals(type)) {
            return Collections.emptySet();
        }
        if (!type.isPrimitive()) {
            return null;
        }
        if (Void.TYPE.equals(type)) {
            return null;
        }
        if (Boolean.TYPE.equals(type)) {
            return Boolean.FALSE;
        }
        if (Character.TYPE.equals(type)) {
            return Character.valueOf('\u0000');
        }
        if (Byte.TYPE.equals(type)) {
            return (byte)0;
        }
        if (Short.TYPE.equals(type)) {
            return (short)0;
        }
        if (Integer.TYPE.equals(type)) {
            return 0;
        }
        if (Long.TYPE.equals(type)) {
            return 0L;
        }
        if (Float.TYPE.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (Double.TYPE.equals(type)) {
            return 0.0;
        }
        throw new AssertionError();
    }

    private int getParameterIndex(String uri) {
        Annotation[][] anns = this.method.getParameterAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            for (int j = 0; j < anns[i].length; ++j) {
                if (!anns[i][j].annotationType().equals(Iri.class) || !((Iri)anns[i][j]).value().equals(uri)) continue;
                return i;
            }
        }
        throw new UnsupportedOperationException("Parameter not found: " + uri);
    }

    private Object[] getParameters(Method method) {
        Object[] parameters = this.getParameters();
        Annotation[][] anns = method.getParameterAnnotations();
        Object[] result = new Object[anns.length];
        for (int i = 0; i < anns.length; ++i) {
            if (i < parameters.length) {
                result[i] = parameters[i];
            }
            for (int j = 0; j < anns[i].length; ++j) {
                if (!anns[i][j].annotationType().equals(Iri.class)) continue;
                String uri = ((Iri)anns[i][j]).value();
                result[i] = parameters[this.getParameterIndex(uri)];
            }
        }
        return result;
    }

    private static class VoidInvocation
    extends Invocation
    implements VoidMessage {
        public VoidInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public void proceed() throws Exception {
            this.delegate.proceed();
        }
    }

    private static class ShortInvocation
    extends Invocation
    implements ShortMessage {
        public ShortInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public short proceed() throws Exception {
            return (Short)this.delegate.proceed();
        }
    }

    private static class LongInvocation
    extends Invocation
    implements LongMessage {
        public LongInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public long proceed() throws Exception {
            return (Long)this.delegate.proceed();
        }
    }

    private static class IntegerInvocation
    extends Invocation
    implements IntegerMessage {
        public IntegerInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public int proceed() throws Exception {
            return (Integer)this.delegate.proceed();
        }
    }

    private static class FloatInvocation
    extends Invocation
    implements FloatMessage {
        public FloatInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public float proceed() throws Exception {
            return ((Float)this.delegate.proceed()).floatValue();
        }
    }

    private static class DoubleInvocation
    extends Invocation
    implements DoubleMessage {
        public DoubleInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public double proceed() throws Exception {
            return (Double)this.delegate.proceed();
        }
    }

    private static class CharacterInvocation
    extends Invocation
    implements CharacterMessage {
        public CharacterInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public char proceed() throws Exception {
            return ((Character)this.delegate.proceed()).charValue();
        }
    }

    private static class ByteInvocation
    extends Invocation
    implements ByteMessage {
        public ByteInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public byte proceed() throws Exception {
            return (Byte)this.delegate.proceed();
        }
    }

    private static class BooleanInvocation
    extends Invocation
    implements BooleanMessage {
        public BooleanInvocation(ObjectMessage delegate) {
            super(delegate);
        }

        @Override
        public boolean proceed() throws Exception {
            return (Boolean)this.delegate.proceed();
        }
    }

    private static class Invocation
    implements MessageContext {
        protected final ObjectMessage delegate;

        public Invocation(ObjectMessage delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object getTarget() {
            return this.delegate.getTarget();
        }

        @Override
        public Method getMethod() {
            return this.delegate.getMethod();
        }

        @Override
        public Object[] getParameters() {
            return this.delegate.getParameters();
        }

        @Override
        public void setParameters(Object[] parameters) {
            this.delegate.setParameters(parameters);
        }
    }
}

