/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.annotations.Iri;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.LangString;
import org.openrdf.repository.object.exceptions.ObjectConversionException;
import org.openrdf.repository.object.managers.Marshall;
import org.openrdf.repository.object.managers.converters.BigDecimalMarshall;
import org.openrdf.repository.object.managers.converters.BigIntegerMarshall;
import org.openrdf.repository.object.managers.converters.BooleanMarshall;
import org.openrdf.repository.object.managers.converters.ByteArrayMarshall;
import org.openrdf.repository.object.managers.converters.ByteMarshall;
import org.openrdf.repository.object.managers.converters.CharacterMarshall;
import org.openrdf.repository.object.managers.converters.ClassMarshall;
import org.openrdf.repository.object.managers.converters.DateMarshall;
import org.openrdf.repository.object.managers.converters.DocumentFragmentMarshall;
import org.openrdf.repository.object.managers.converters.DoubleMarshall;
import org.openrdf.repository.object.managers.converters.DurationMarshall;
import org.openrdf.repository.object.managers.converters.FloatMarshall;
import org.openrdf.repository.object.managers.converters.GregorianCalendarMarshall;
import org.openrdf.repository.object.managers.converters.IntegerMarshall;
import org.openrdf.repository.object.managers.converters.LangStringMarshall;
import org.openrdf.repository.object.managers.converters.LocaleMarshall;
import org.openrdf.repository.object.managers.converters.LongMarshall;
import org.openrdf.repository.object.managers.converters.ObjectConstructorMarshall;
import org.openrdf.repository.object.managers.converters.ObjectSerializationMarshall;
import org.openrdf.repository.object.managers.converters.PatternMarshall;
import org.openrdf.repository.object.managers.converters.QNameMarshall;
import org.openrdf.repository.object.managers.converters.ShortMarshall;
import org.openrdf.repository.object.managers.converters.SqlDateMarshall;
import org.openrdf.repository.object.managers.converters.SqlTimeMarshall;
import org.openrdf.repository.object.managers.converters.SqlTimestampMarshall;
import org.openrdf.repository.object.managers.converters.StringMarshall;
import org.openrdf.repository.object.managers.converters.ValueOfMarshall;
import org.openrdf.repository.object.managers.converters.XMLGregorianCalendarMarshall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DocumentFragment;

public class LiteralManager
implements Cloneable {
    private static final String JAVA_NS = "java:";
    private static final String LITERALS_PROPERTIES = "META-INF/org.openrdf.literals";
    private static final String DATATYPES_PROPERTIES = "META-INF/org.openrdf.datatypes";
    private final Logger logger = LoggerFactory.getLogger(LiteralManager.class);
    private ClassLoader cl;
    private final ValueFactory uf;
    private final ValueFactory lf;
    private final URI STRING;
    private final URI LANG_STRING;
    private ConcurrentMap<URI, Class<?>> javaClasses;
    private ConcurrentMap<String, Marshall<?>> marshalls;
    private ConcurrentMap<Class<?>, URI> rdfTypes;

    public LiteralManager() {
        this((ValueFactory)ValueFactoryImpl.getInstance(), (ValueFactory)ValueFactoryImpl.getInstance());
    }

    public LiteralManager(ClassLoader cl) {
        this((ValueFactory)ValueFactoryImpl.getInstance(), (ValueFactory)ValueFactoryImpl.getInstance());
        this.setClassLoader(cl);
    }

    public LiteralManager(ValueFactory uf, ValueFactory lf) {
        this.uf = uf;
        this.lf = lf;
        this.STRING = uf.createURI(XMLSchema.STRING.toString());
        this.LANG_STRING = uf.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString");
        this.javaClasses = new ConcurrentHashMap();
        this.rdfTypes = new ConcurrentHashMap();
        this.marshalls = new ConcurrentHashMap();
    }

    public LiteralManager clone() {
        try {
            LiteralManager cloned = (LiteralManager)super.clone();
            cloned.javaClasses = new ConcurrentHashMap(this.javaClasses);
            cloned.marshalls = new ConcurrentHashMap(this.marshalls);
            cloned.rdfTypes = new ConcurrentHashMap(this.rdfTypes);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
        try {
            this.recordMarshall(new BigDecimalMarshall(this.lf));
            this.recordMarshall(new BigIntegerMarshall(this.lf));
            this.recordMarshall(new BooleanMarshall(this.lf));
            this.recordMarshall(new ByteArrayMarshall(this.lf));
            this.recordMarshall(new ByteMarshall(this.lf));
            this.recordMarshall(new DoubleMarshall(this.lf));
            this.recordMarshall(new FloatMarshall(this.lf));
            this.recordMarshall(new IntegerMarshall(this.lf));
            this.recordMarshall(new LongMarshall(this.lf));
            this.recordMarshall(new ShortMarshall(this.lf));
            this.recordMarshall(new CharacterMarshall(this.lf));
            this.recordMarshall(new DateMarshall(this.lf));
            this.recordMarshall(new LocaleMarshall(this.lf));
            this.recordMarshall(new PatternMarshall(this.lf));
            this.recordMarshall(new QNameMarshall(this.lf));
            this.recordMarshall(new GregorianCalendarMarshall(this.lf));
            this.recordMarshall(new SqlDateMarshall(this.lf));
            this.recordMarshall(new SqlTimeMarshall(this.lf));
            this.recordMarshall(new SqlTimestampMarshall(this.lf));
            this.recordMarshall(new ClassMarshall(this.lf, cl));
            DocumentFragmentMarshall dfm = new DocumentFragmentMarshall(this.lf);
            this.recordMarshall(dfm.getJavaClassName(), dfm);
            this.recordMarshall(DocumentFragment.class, dfm);
            DurationMarshall dm = new DurationMarshall(this.lf);
            this.recordMarshall(dm.getJavaClassName(), dm);
            this.recordMarshall(Duration.class, dm);
            XMLGregorianCalendarMarshall xgcm = new XMLGregorianCalendarMarshall(this.lf);
            this.recordMarshall(xgcm.getJavaClassName(), xgcm);
            this.recordMarshall(XMLGregorianCalendar.class, xgcm);
            this.recordMarshall(new StringMarshall(this.lf));
            this.recordMarshall(new StringMarshall(this.lf, "org.codehaus.groovy.runtime.GStringImpl"));
            this.recordMarshall(new StringMarshall(this.lf, "groovy.lang.GString$1"));
            this.recordMarshall(new StringMarshall(this.lf, "groovy.lang.GString$2"));
            this.recordMarshall(new LangStringMarshall<LangString>(this.lf, LangString.class));
            this.recordMarshall(new LangStringMarshall<CharSequence>(this.lf, CharSequence.class));
            this.loadDatatypes(LiteralManager.class.getClassLoader(), DATATYPES_PROPERTIES);
            this.loadDatatypes(cl, DATATYPES_PROPERTIES);
            this.loadDatatypes(cl, LITERALS_PROPERTIES);
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findClass(URI datatype) {
        if (this.javaClasses.containsKey(datatype)) {
            return (Class)this.javaClasses.get(datatype);
        }
        try {
            if (datatype.getNamespace().equals(JAVA_NS)) {
                ClassLoader classLoader = this.cl;
                synchronized (classLoader) {
                    return Class.forName(datatype.getLocalName(), true, this.cl);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new ObjectConversionException(e);
        }
        return null;
    }

    public boolean isRecordedeType(URI datatype) {
        return this.findClass(datatype) != null;
    }

    public URI findDatatype(Class<?> type) {
        if (type.equals(String.class)) {
            return null;
        }
        if (this.rdfTypes.containsKey(type)) {
            return (URI)this.rdfTypes.get(type);
        }
        URI datatype = this.uf.createURI(JAVA_NS, type.getName());
        this.recordType(type, datatype);
        return datatype;
    }

    public Literal createLiteral(Object object) {
        Marshall<?> marshall = this.findMarshall(object.getClass());
        return marshall.serialize(object);
    }

    public Literal createLiteral(String value, String language) {
        return this.lf.createLiteral(value, language);
    }

    public Object createObject(Literal literal) {
        URI datatype = literal.getDatatype();
        if (datatype == null) {
            datatype = literal.getLanguage() == null ? this.STRING : this.LANG_STRING;
        }
        Marshall<?> marshall = this.findMarshall(datatype);
        return marshall.deserialize(literal);
    }

    public void recordMarshall(String javaClassName, Marshall<?> marshall) {
        this.marshalls.put(javaClassName, marshall);
    }

    public void recordMarshall(Class<?> javaClass, Marshall<?> marshall) {
        this.recordMarshall(javaClass.getName(), marshall);
    }

    public void addDatatype(Class<?> javaClass, URI datatype) {
        this.recordType(javaClass, datatype);
    }

    public boolean isDatatype(Class<?> type) {
        return this.rdfTypes.containsKey(type);
    }

    private void recordType(Class<?> javaClass, URI datatype) {
        if (!this.javaClasses.containsKey(datatype)) {
            this.javaClasses.putIfAbsent(datatype, javaClass);
        }
        if (this.rdfTypes.putIfAbsent(javaClass, datatype) == null) {
            Marshall<?> marshall = this.findMarshall(javaClass);
            marshall.setDatatype(datatype);
        }
    }

    private <T> Marshall<T> findMarshall(Class<T> type) {
        Marshall<T> marshall;
        String name;
        block7: {
            name = type.getName();
            if (this.marshalls.containsKey(name)) {
                return (Marshall)this.marshalls.get(name);
            }
            try {
                marshall = new ValueOfMarshall<T>(this.lf, type);
            }
            catch (NoSuchMethodException e1) {
                try {
                    marshall = new ObjectConstructorMarshall<T>(this.lf, type);
                }
                catch (NoSuchMethodException e2) {
                    if (Serializable.class.isAssignableFrom(type)) {
                        marshall = new ObjectSerializationMarshall<T>(this.lf, type);
                        break block7;
                    }
                    throw new ObjectConversionException(e1);
                }
            }
        }
        Marshall o = this.marshalls.putIfAbsent(name, marshall);
        if (o != null) {
            marshall = o;
        }
        return marshall;
    }

    private Marshall<?> findMarshall(URI datatype) {
        Class<?> type;
        if (this.javaClasses.containsKey(datatype)) {
            type = (Class<?>)this.javaClasses.get(datatype);
        } else if (datatype.getNamespace().equals(JAVA_NS)) {
            try {
                type = this.forName(datatype.getLocalName(), true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectConversionException(e);
            }
        } else {
            throw new ObjectConversionException("Unknown datatype: " + datatype);
        }
        return this.findMarshall(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> forName(String name, boolean init, ClassLoader cl) throws ClassNotFoundException {
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return Class.forName(name, init, cl);
        }
    }

    private void loadDatatypes(ClassLoader cl, String properties) throws IOException, ClassNotFoundException {
        if (cl == null) {
            return;
        }
        Enumeration<URL> resources = cl.getResources(properties);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            try {
                Properties p = new Properties();
                p.load(url.openStream());
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    String className = (String)e.getKey();
                    String types = (String)e.getValue();
                    Class<?> lc = this.forName(className, true, cl);
                    boolean present = lc.isAnnotationPresent(Iri.class);
                    for (String rdf : types.split("\\s+")) {
                        if (rdf.length() == 0 && present) {
                            rdf = lc.getAnnotation(Iri.class).value();
                            this.recordType(lc, this.uf.createURI(rdf));
                            continue;
                        }
                        if (rdf.length() == 0) {
                            this.logger.warn("Unkown datatype mapping {}", (Object)className);
                            continue;
                        }
                        this.recordType(lc, this.uf.createURI(rdf));
                    }
                }
            }
            catch (IOException e) {
                String msg = e.getMessage() + " in: " + url;
                IOException ioe = new IOException(msg);
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private void recordMarshall(Marshall<?> marshall) {
        this.recordMarshall(marshall.getJavaClassName(), marshall);
    }
}

