/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openrdf.annotations.Iri;
import org.openrdf.model.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapper {
    private static final String PROPERTIES = "META-INF/org.openrdf.properties";
    private static final String GET_PREFIX = "get";
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private Logger logger = LoggerFactory.getLogger(PropertyMapper.class);
    private boolean readTypes;
    private Properties properties = new Properties();

    public PropertyMapper(ClassLoader cl, boolean readTypes) {
        this.loadProperties(cl);
        this.readTypes = readTypes;
    }

    public boolean isReadingTypes() {
        return this.readTypes;
    }

    public Collection<Field> findFields(Class<?> concept) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : concept.getDeclaredFields()) {
            if (!this.isMappedField(field)) continue;
            fields.add(field);
        }
        return fields;
    }

    public Collection<PropertyDescriptor> findProperties(Class<?> concept) {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        for (Method method : concept.getDeclaredMethods()) {
            if (!this.isMappedGetter(method)) continue;
            properties.add(this.createPropertyDescriptor(method));
        }
        return properties;
    }

    public String findPredicate(Field field) {
        Class<?> dc = field.getDeclaringClass();
        String key = dc.getName() + "#" + field.getName();
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        Iri rdf = field.getAnnotation(Iri.class);
        if (rdf == null) {
            return null;
        }
        return rdf.value();
    }

    public String findPredicate(PropertyDescriptor pd) {
        Method method = pd.getReadMethod();
        Class<?> dc = method.getDeclaringClass();
        String key = dc.getName() + "." + this.getPropertyName(method);
        if (this.properties.containsKey(key)) {
            return (String)this.properties.get(key);
        }
        Method getter = method;
        Iri rdf = getter.getAnnotation(Iri.class);
        if (rdf == null) {
            return null;
        }
        return rdf.value();
    }

    public Collection<PropertyDescriptor> findFunctionalProperties(Class<?> type) {
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        this.findFunctionalProperties(type, properties);
        return properties.values();
    }

    public Collection<Field> findFunctionalFields(Class<?> type) {
        if (type.isInterface()) {
            return Collections.emptySet();
        }
        HashMap<String, Field> properties = new HashMap<String, Field>();
        this.findFunctionalFields(type, properties);
        return properties.values();
    }

    public Map<String, String> findEagerProperties(Class<?> type) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.findEagerProperties(type, properties);
        if (properties.isEmpty()) {
            return null;
        }
        if (this.readTypes) {
            properties.put("class", RDF.TYPE.stringValue());
        }
        return properties;
    }

    public boolean isMappedField(Field field) {
        if (field.isAnnotationPresent(Iri.class)) {
            return true;
        }
        if (this.properties.isEmpty()) {
            return false;
        }
        String name = field.getDeclaringClass().getName();
        String key = name + "#" + field.getName();
        return this.properties.containsKey(key);
    }

    private void findFunctionalProperties(Class<?> concept, Map<String, PropertyDescriptor> properties) {
        for (PropertyDescriptor pd : this.findProperties(concept)) {
            Class<?> type = pd.getPropertyType();
            if (Set.class.equals(type)) continue;
            properties.put(pd.getName(), pd);
        }
        for (Class<?> face : concept.getInterfaces()) {
            this.findFunctionalProperties(face, properties);
        }
        if (concept.getSuperclass() != null) {
            this.findFunctionalProperties(concept.getSuperclass(), properties);
        }
    }

    private void findFunctionalFields(Class<?> concept, Map<String, Field> properties) {
        for (Field field : this.findFields(concept)) {
            Class<?> type = field.getType();
            if (Set.class.equals(type)) continue;
            properties.put(field.getName(), field);
        }
        if (concept.getSuperclass() != null) {
            this.findFunctionalFields(concept.getSuperclass(), properties);
        }
    }

    private Map<String, String> findEagerProperties(Class<?> concept, Map<String, String> properties) {
        Class<?> type;
        for (PropertyDescriptor pd : this.findProperties(concept)) {
            type = pd.getPropertyType();
            Type type2 = pd.getReadMethod().getGenericReturnType();
            if (!this.isEagerPropertyType(type2, type)) continue;
            properties.put(pd.getName(), this.findPredicate(pd));
        }
        for (Field field : this.findFields(concept)) {
            type = field.getType();
            if (!this.isEagerPropertyType(field.getGenericType(), type)) continue;
            properties.put(field.getName(), this.findPredicate(field));
        }
        for (Iterator<Object> iterator : concept.getInterfaces()) {
            this.findEagerProperties((Class<?>)((Object)iterator), properties);
        }
        if (concept.getSuperclass() == null) {
            return properties;
        }
        return this.findEagerProperties(concept.getSuperclass(), properties);
    }

    private boolean isEagerPropertyType(Type t, Class<?> type) {
        if (Set.class.equals(type)) {
            return false;
        }
        if (!this.readTypes) {
            return true;
        }
        if (type.isInterface()) {
            return false;
        }
        if (Object.class.equals(type)) {
            return false;
        }
        return !type.isAnnotationPresent(Iri.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(ClassLoader cl) {
        try {
            Enumeration<URL> resources = cl.getResources(PROPERTIES);
            while (resources.hasMoreElements()) {
                try {
                    InputStream stream = resources.nextElement().openStream();
                    try {
                        this.properties.load(stream);
                    }
                    finally {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn(e.toString(), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            this.logger.warn(e.toString(), (Throwable)e);
        }
    }

    private boolean isMappedGetter(Method method) {
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (this.getPropertyName(method) == null) {
            return false;
        }
        if (method.isAnnotationPresent(Iri.class)) {
            return true;
        }
        if (this.properties.isEmpty()) {
            return false;
        }
        String name = method.getDeclaringClass().getName();
        String key = name + "." + this.getPropertyName(method);
        return this.properties.containsKey(key);
    }

    private PropertyDescriptor createPropertyDescriptor(Method method) {
        String property = this.getPropertyName(method);
        Method setter = this.getSetterMethod(property, method);
        try {
            return new PropertyDescriptor(property, method, setter);
        }
        catch (IntrospectionException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getPropertyName(Method method) {
        boolean bool;
        String name = method.getName();
        boolean bl = bool = method.getReturnType() == Boolean.TYPE;
        if (name.startsWith(GET_PREFIX) && name.length() > 3) {
            return PropertyMapper.decapitalize(name.substring(3));
        }
        if (bool && name.startsWith(IS_PREFIX) && name.length() > 2) {
            return PropertyMapper.decapitalize(name.substring(2));
        }
        return null;
    }

    private static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private Method getSetterMethod(String property, Method getter) {
        try {
            Class<?> dc = getter.getDeclaringClass();
            Class<?> rt = getter.getReturnType();
            String setter = SET_PREFIX + PropertyMapper.capitalize(property);
            return dc.getDeclaredMethod(setter, rt);
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }
}

