/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Mixin;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.managers.helpers.HierarchicalRoleMapper;
import org.openrdf.repository.object.managers.helpers.RoleMatcher;
import org.openrdf.repository.object.vocabulary.MSG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleMapper
implements Cloneable {
    private ValueFactory vf;
    private Logger logger = LoggerFactory.getLogger(RoleMapper.class);
    private HierarchicalRoleMapper roleMapper = new HierarchicalRoleMapper();
    private Map<URI, List<Class<?>>> instances = new ConcurrentHashMap(256);
    private RoleMatcher matches = new RoleMatcher();
    private Map<Method, URI> annotations = new HashMap<Method, URI>();
    private Map<URI, Method> annotationURIs = new HashMap<URI, Method>();
    private Map<Class<?>, String> complementIDs;
    private Map<Class<?>, Class<?>> complementClasses;
    private Map<Class<?>, List<Class<?>>> intersections;
    private Set<Class<?>> conceptClasses = new HashSet();

    public RoleMapper() {
        this((ValueFactory)ValueFactoryImpl.getInstance());
    }

    public RoleMapper(ValueFactory vf) {
        this.vf = vf;
        this.roleMapper.setURIFactory(vf);
        this.complementIDs = new ConcurrentHashMap();
        this.complementClasses = new ConcurrentHashMap();
        this.intersections = new ConcurrentHashMap();
    }

    public RoleMapper clone() {
        try {
            RoleMapper cloned = (RoleMapper)super.clone();
            cloned.roleMapper = this.roleMapper.clone();
            cloned.instances = this.clone(this.instances);
            cloned.matches = this.matches.clone();
            cloned.annotations = new HashMap<Method, URI>(this.annotations);
            cloned.annotationURIs = new HashMap<URI, Method>(this.annotationURIs);
            cloned.complementIDs = new ConcurrentHashMap(this.complementIDs);
            cloned.complementClasses = new ConcurrentHashMap(this.complementClasses);
            cloned.intersections = this.clone(this.intersections);
            cloned.conceptClasses = new HashSet(this.conceptClasses);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    private <K, V> Map<K, List<V>> clone(Map<K, List<V>> map) {
        ConcurrentHashMap<K, List<V>> cloned = new ConcurrentHashMap<K, List<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new CopyOnWriteArrayList((Collection)entry.getValue()));
        }
        return cloned;
    }

    public Collection<Class<?>> getConceptClasses() {
        return this.conceptClasses;
    }

    public Collection<Class<?>> findIndividualRoles(URI instance, Collection<Class<?>> classes) {
        List<Class<?>> list = this.instances.get(instance);
        if (list != null) {
            classes.addAll(list);
            this.addImpliedRoles(list, classes);
        }
        list = new ArrayList();
        this.matches.findRoles(instance.stringValue(), list);
        classes.addAll(list);
        this.addImpliedRoles(list, classes);
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecordedConcept(URI type, ClassLoader cl) {
        if (this.roleMapper.isTypeRecorded(type)) {
            for (Class<?> role : this.findAllRoles(type)) {
                if (this.findType(role) == null) continue;
                return true;
            }
        }
        if ("java:".equals(type.getNamespace())) {
            try {
                ClassLoader classLoader = cl;
                synchronized (classLoader) {
                    Class.forName(type.getLocalName(), true, cl);
                }
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    public Class<?> findInterfaceConcept(URI uri) {
        Class<?> concept = null;
        Class<?> mapped = null;
        Collection<Class<?>> rs = this.findAllRoles(uri);
        for (Class<?> r : rs) {
            URI type = this.findType(r);
            if (!r.isInterface() || type == null) continue;
            concept = r;
            if (!uri.equals((Object)type)) continue;
            mapped = r;
            if (!r.getSimpleName().equals(uri.getLocalName())) continue;
            return r;
        }
        if (mapped != null) {
            return mapped;
        }
        if (concept != null) {
            return concept;
        }
        return null;
    }

    public Class<?> findConcept(URI uri, ClassLoader cl) {
        if (this.roleMapper.isTypeRecorded(uri)) {
            Class<?> concept = null;
            Class<?> mapped = null;
            Class<?> face = null;
            Collection<Class<?>> rs = this.findAllRoles(uri);
            for (Class<?> r : rs) {
                URI type = this.findType(r);
                if (type != null && r.isInterface()) {
                    concept = r;
                }
                if (!uri.equals((Object)type)) continue;
                mapped = r;
                if (r.getSimpleName().equals(uri.getLocalName())) {
                    return r;
                }
                if (!r.isInterface()) continue;
                face = r;
            }
            if (face != null) {
                return face;
            }
            if (mapped != null) {
                return mapped;
            }
            if (concept != null) {
                return concept;
            }
        }
        if ("java:".equals(uri.getNamespace())) {
            try {
                if (cl == null) {
                    ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                    return Class.forName(uri.getLocalName(), true, ccl);
                }
                return Class.forName(uri.getLocalName(), true, cl);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public Collection<Class<?>> findRoles(URI type) {
        return this.findAdditionalRoles(this.roleMapper.findRoles(type));
    }

    public Collection<Class<?>> findRoles(Collection<URI> types, Collection<Class<?>> roles) {
        return this.findAdditionalRoles(this.roleMapper.findRoles(types, roles));
    }

    public Collection<Class<?>> findAdditionalRoles(Collection<Class<?>> classes) {
        if (this.intersections.isEmpty() && this.complementIDs.isEmpty() && this.complementClasses.isEmpty()) {
            return classes;
        }
        ArrayList result = new ArrayList(classes.size() * 2 + 2);
        result.addAll(classes);
        int before = result.size();
        this.addIntersectionsAndComplements(result);
        int after = result.size();
        if (before != after) {
            ArrayList anonymous = new ArrayList(result.subList(before, after));
            this.addImpliedRoles(anonymous, result);
        }
        return result;
    }

    public Collection<URI> findSubTypes(Class<?> role, Collection<URI> rdfTypes) {
        return this.roleMapper.findSubTypes(role, rdfTypes);
    }

    public URI findType(Class<?> concept) {
        return this.roleMapper.findType(concept);
    }

    public boolean isNamedTypePresent() {
        return this.roleMapper.isNamedTypePresent();
    }

    public boolean isIndividualRolesPresent(URI instance) {
        return !this.matches.isEmpty() || !this.instances.isEmpty() && this.instances.containsKey(instance);
    }

    public URI findAnnotation(Method ann) {
        return this.annotations.get(ann);
    }

    public Method findAnnotationMethod(URI uri) {
        return this.annotationURIs.get(uri);
    }

    public boolean isRecordedAnnotation(URI uri) {
        return this.findAnnotationMethod(uri) != null;
    }

    public void addAnnotation(Class<?> annotation) {
        for (Method m : annotation.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Iri.class)) {
                String msg = "@" + Iri.class.getSimpleName() + " annotation required in " + m.toGenericString();
                throw new IllegalArgumentException(msg);
            }
            String uri = m.getAnnotation(Iri.class).value();
            this.addAnnotation(m, (URI)new URIImpl(uri));
        }
    }

    public void addAnnotation(Class<?> annotation, URI uri) {
        if (annotation.getDeclaredMethods().length != 1) {
            throw new IllegalArgumentException("Must specify annotation method if multiple methods exist: " + annotation);
        }
        this.addAnnotation(annotation.getDeclaredMethods()[0], uri);
    }

    public void addAnnotation(Method annotation) {
        if (!annotation.isAnnotationPresent(Iri.class)) {
            throw new IllegalArgumentException("@" + Iri.class.getSimpleName() + " annotation required in " + annotation.toGenericString());
        }
        String uri = annotation.getAnnotation(Iri.class).value();
        this.addAnnotation(annotation, (URI)new URIImpl(uri));
    }

    public void addAnnotation(Method annotation, URI uri) {
        this.annotations.put(annotation, uri);
        this.annotationURIs.put(uri, annotation);
        if (annotation.isAnnotationPresent(Iri.class)) {
            String iri = annotation.getAnnotation(Iri.class).value();
            if (!uri.stringValue().equals(iri)) {
                this.addAnnotation(annotation);
            }
        }
    }

    public void addConcept(Class<?> role) throws ObjectStoreConfigException {
        this.recordRole(role, role, null, true, true, true);
    }

    public void addConcept(Class<?> role, URI type) throws ObjectStoreConfigException {
        this.recordRole(role, role, type, true, true, true);
    }

    public void addBehaviour(Class<?> role) throws ObjectStoreConfigException {
        this.assertBehaviour(role);
        boolean hasType = false;
        for (Class<?> face : role.getInterfaces()) {
            boolean recorded = this.recordRole(role, face, null, true, false, false);
            if (recorded && hasType) {
                throw new ObjectStoreConfigException(role.getSimpleName() + " can only implement one concept");
            }
            hasType |= recorded;
        }
        if (!hasType) {
            throw new ObjectStoreConfigException(role.getSimpleName() + " must implement a concept or mapped explicitly");
        }
    }

    public void addBehaviour(Class<?> role, URI type) throws ObjectStoreConfigException {
        this.assertBehaviour(role);
        this.recordRole(role, null, type, true, false, false);
    }

    private void assertBehaviour(Class<?> role) throws ObjectStoreConfigException {
        if (this.isAnnotationPresent(role)) {
            throw new ObjectStoreConfigException(role.getSimpleName() + " cannot have a concept annotation");
        }
        if (role.isInterface()) {
            throw new ObjectStoreConfigException(role.getSimpleName() + " is an interface and not a behaviour");
        }
        for (Method method : role.getDeclaredMethods()) {
            if (!this.isAnnotationPresent(method) || !method.getName().startsWith("get")) continue;
            throw new ObjectStoreConfigException(role.getSimpleName() + " cannot have a property annotation");
        }
    }

    private Collection<Class<?>> findAllRoles(URI type) {
        HashSet set = new HashSet();
        for (Class<?> role : this.findRoles(type)) {
            if (!set.add(role)) continue;
            this.addInterfaces(set, role.getSuperclass());
            this.addInterfaces(set, role.getInterfaces());
        }
        return set;
    }

    private void addInterfaces(Set<Class<?>> set, Class<?> ... list) {
        for (Class<?> c : list) {
            if (c == null || !set.add(c)) continue;
            this.addInterfaces(set, c.getSuperclass());
            this.addInterfaces(set, c.getInterfaces());
        }
    }

    private boolean isAnnotationPresent(AnnotatedElement role) throws ObjectStoreConfigException {
        return role.isAnnotationPresent(Iri.class);
    }

    private boolean recordRole(Class<?> role, Class<?> elm, URI rdfType, boolean equiv, boolean concept, boolean primary) throws ObjectStoreConfigException {
        boolean hasType = false;
        if (rdfType != null) {
            if (concept) {
                this.roleMapper.recordConcept(role, rdfType, equiv, primary);
            } else {
                this.roleMapper.recordBehaviour(role, rdfType, equiv);
            }
            hasType = true;
        } else if (elm != null) {
            URI defType = this.findDefaultType(elm);
            if (defType != null) {
                if (concept) {
                    this.roleMapper.recordConcept(role, defType, equiv, role.equals(elm));
                } else {
                    this.roleMapper.recordBehaviour(role, defType, equiv);
                }
                hasType = true;
            }
            hasType |= this.recordAnonymous(role, elm, concept);
        }
        if (!hasType && elm != null) {
            for (Class<?> face : elm.getInterfaces()) {
                hasType |= this.recordRole(role, face, null, equiv, concept, false);
            }
        }
        if (!hasType && primary) {
            throw new ObjectStoreConfigException(role.getSimpleName() + " does not have an RDF type mapping");
        }
        this.recordMixins(role, elm, rdfType);
        if (concept && !role.isInterface()) {
            this.conceptClasses.add(role);
        }
        return hasType;
    }

    private void recordMixins(Class<?> role, Class<?> elm, URI rdfType) throws ObjectStoreConfigException {
        Mixin mixin = role.getAnnotation(Mixin.class);
        if (mixin != null) {
            for (Class<?> mix : mixin.value()) {
                this.assertBehaviour(mix);
                this.recordRole(mix, elm, rdfType, true, false, false);
            }
            for (String name : mixin.name()) {
                Class<?> mix = this.findClass(name, role.getClassLoader());
                if (mix != null) {
                    this.assertBehaviour(mix);
                    this.recordRole(mix, elm, rdfType, true, false, false);
                    continue;
                }
                this.logger.error("Could not find {}", (Object)name);
            }
        }
    }

    private Class<?> findClass(String name, ClassLoader cl) {
        try {
            return Class.forName(name, true, cl);
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            return null;
        }
    }

    private boolean recordAnonymous(Class<?> role, Class<?> elm, boolean isConcept) throws ObjectStoreConfigException {
        boolean recorded = false;
        for (Annotation ann : elm.getAnnotations()) {
            for (Method m : ann.annotationType().getDeclaredMethods()) {
                try {
                    URI name = this.findAnnotation(m);
                    if (name == null && m.isAnnotationPresent(Iri.class)) {
                        this.addAnnotation(m);
                        name = this.findAnnotation(m);
                    }
                    if (name == null) continue;
                    Object value = m.invoke((Object)ann, new Object[0]);
                    recorded |= this.recordAnonymous(role, isConcept, name, value);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return recorded;
    }

    private boolean recordAnonymous(Class<?> role, boolean isConcept, URI name, Object value) throws ObjectStoreConfigException {
        URI uri;
        Class concept;
        Object v;
        int n;
        int n2;
        Object[] objectArray;
        Object[] values;
        boolean recorded = false;
        if (OWL.EQUIVALENTCLASS.equals((Object)name)) {
            objectArray = values = (Object[])value;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                v = objectArray[n];
                if (v instanceof Class) {
                    concept = (Class)v;
                    URI uri2 = this.findDefaultType(concept);
                    if (uri2 == null) continue;
                    recorded |= this.recordRole(role, concept, uri2, true, isConcept, false);
                    continue;
                }
                if (v instanceof String) {
                    uri = this.vf.createURI((String)v);
                    recorded |= this.recordRole(role, role, uri, true, isConcept, false);
                    continue;
                }
                this.logger.error("{} must have a value of type Class[] or String[]", (Object)name);
            }
        }
        if (MSG.MATCHING.equals((Object)name)) {
            objectArray = values = (String[])value;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object pattern = objectArray[n];
                this.matches.addRoles((String)pattern, role);
                recorded = true;
            }
        }
        if (OWL.ONEOF.equals((Object)name)) {
            objectArray = values = (String[])value;
            n2 = objectArray.length;
            for (n = 0; n < n2; ++n) {
                Object instance = objectArray[n];
                uri = this.vf.createURI((String)instance);
                List<Class<?>> list = this.instances.get(uri);
                if (list == null) {
                    list = new CopyOnWriteArrayList();
                    this.instances.put(uri, list);
                }
                list.add(role);
                recorded = true;
            }
        }
        if (OWL.COMPLEMENTOF.equals((Object)name)) {
            if (value instanceof Object[]) {
                Object[] ar = (Object[])value;
                if (ar.length != 1) {
                    this.logger.error("{} must have exactly one value", (Object)name);
                }
                value = ar[0];
            }
            if (value instanceof Class) {
                Class concept2 = (Class)value;
                this.recordRole(concept2, concept2, null, true, true, true);
                this.complementClasses.put(role, concept2);
                recorded = true;
            } else if (value instanceof String) {
                this.complementIDs.put(role, (String)value);
                recorded = true;
            } else {
                this.logger.error("{} must have a value of type Class or String", (Object)name);
            }
        }
        if (OWL.INTERSECTIONOF.equals((Object)name)) {
            ArrayList ofs = new ArrayList();
            objectArray = (Object[])value;
            n2 = objectArray.length;
            block3: for (n = 0; n < n2; ++n) {
                v = objectArray[n];
                if (v instanceof Class) {
                    concept = (Class)v;
                    this.recordRole(concept, concept, null, true, true, true);
                    ofs.add(concept);
                    continue;
                }
                if (v instanceof String) {
                    Class<?> superclass = role.getSuperclass();
                    if (superclass != null && superclass.isAnnotationPresent(Iri.class) && v.equals(superclass.getAnnotation(Iri.class).value())) {
                        this.recordRole(superclass, superclass, null, true, true, true);
                        ofs.add(superclass);
                        continue;
                    }
                    for (Class<?> sp : role.getInterfaces()) {
                        if (!sp.isAnnotationPresent(Iri.class) || !v.equals(sp.getAnnotation(Iri.class).value())) continue;
                        this.recordRole(sp, sp, null, true, true, true);
                        ofs.add(sp);
                        continue block3;
                    }
                    this.logger.error("{} can only reference super classes", (Object)name);
                    continue;
                }
                this.logger.error("{} must have a value of type Class[] or String[]", (Object)name);
            }
            this.intersections.put(role, ofs);
            recorded = true;
        }
        if (OWL.UNIONOF.equals((Object)name)) {
            for (Object v2 : (Object[])value) {
                if (v2 instanceof Class) {
                    Class concept3 = (Class)v2;
                    this.recordRole(concept3, concept3, null, true, true, true);
                    if (role.isAssignableFrom(concept3)) {
                        recorded = true;
                        continue;
                    }
                    recorded |= this.recordRole(role, concept3, null, false, isConcept, false);
                    continue;
                }
                if (v2 instanceof String) {
                    recorded |= this.recordRole(role, null, this.vf.createURI((String)v2), false, isConcept, false);
                    continue;
                }
                this.logger.error("{} must have a value of type Class[] or String[]", (Object)name);
            }
        }
        return recorded;
    }

    private URI findDefaultType(AnnotatedElement elm) {
        String value;
        if (elm.isAnnotationPresent(Iri.class) && (value = elm.getAnnotation(Iri.class).value()) != null) {
            return this.vf.createURI(value);
        }
        return null;
    }

    private void addIntersectionsAndComplements(Collection<Class<?>> roles) {
        Object of;
        Class<?> comp;
        for (Map.Entry<Class<?>, List<Class<?>>> e : this.intersections.entrySet()) {
            Class<?> clazz = e.getKey();
            List<Class<?>> of2 = e.getValue();
            if (roles.contains(clazz) || !this.intersects(roles, of2)) continue;
            roles.add(clazz);
        }
        if (this.complementIDs.isEmpty() && this.complementClasses.isEmpty()) {
            return;
        }
        boolean complementAdded = false;
        for (Map.Entry<Class<?>, String> entry : this.complementIDs.entrySet()) {
            comp = entry.getKey();
            of = entry.getValue();
            if (roles.contains(comp) || this.contains(roles, (String)of)) continue;
            complementAdded = true;
            roles.add(comp);
        }
        for (Map.Entry<Class<?>, Object> entry : this.complementClasses.entrySet()) {
            comp = entry.getKey();
            of = (Class)entry.getValue();
            if (roles.contains(comp) || this.contains(roles, (Class<?>)of)) continue;
            complementAdded = true;
            roles.add(comp);
        }
        if (!complementAdded) {
            return;
        }
        for (Map.Entry<Class<?>, Object> entry : this.intersections.entrySet()) {
            Class<?> inter = entry.getKey();
            of = (List)entry.getValue();
            if (roles.contains(inter) || !this.intersects(roles, (Collection<Class<?>>)of)) continue;
            roles.add(inter);
        }
    }

    private void addImpliedRoles(Collection<Class<?>> anonymous, Collection<Class<?>> result) {
        for (Class<?> r : anonymous) {
            URI uri;
            Class<?> sc = r.getSuperclass();
            if (sc != null && (uri = this.findType(sc)) != null) {
                result.addAll(this.roleMapper.findRoles(uri));
            }
            for (Class<?> c : r.getInterfaces()) {
                URI uri2 = this.findType(c);
                if (uri2 == null) continue;
                result.addAll(this.roleMapper.findRoles(uri2));
            }
        }
    }

    private boolean intersects(Collection<Class<?>> roles, Collection<Class<?>> ofs) {
        for (Class<?> of : ofs) {
            if (this.contains(roles, of)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(Collection<Class<?>> roles, Class<?> of) {
        for (Class<?> type : roles) {
            if (!of.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Collection<Class<?>> roles, String iri) {
        HashSet set = new HashSet();
        for (Class<?> type : roles) {
            if (!this.isImplementationPresent(type, iri, set)) continue;
            return true;
        }
        return false;
    }

    private boolean isImplementationPresent(Class<?> type, String iri, Set<Class<?>> ignore) {
        if (type == null || ignore.contains(type)) {
            return false;
        }
        Iri id = type.getAnnotation(Iri.class);
        if (id != null && iri.equals(id.value())) {
            return true;
        }
        for (Class<?> face : type.getInterfaces()) {
            if (!this.isImplementationPresent(face, iri, ignore)) continue;
            return true;
        }
        return this.isImplementationPresent(type.getSuperclass(), iri, ignore);
    }
}

