/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.math.BigDecimal;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class BigDecimalMarshall
implements Marshall<BigDecimal> {
    private ValueFactory vf;
    private URI datatype;

    public BigDecimalMarshall(ValueFactory vf) {
        this.vf = vf;
        this.datatype = XMLSchema.DECIMAL;
    }

    @Override
    public String getJavaClassName() {
        return BigDecimal.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI dt) {
        if (!dt.equals((Object)this.datatype)) {
            throw new IllegalArgumentException(dt.toString());
        }
    }

    @Override
    public BigDecimal deserialize(Literal literal) {
        return literal.decimalValue();
    }

    @Override
    public Literal serialize(BigDecimal object) {
        return this.vf.createLiteral(object.toString(), this.datatype);
    }
}

