/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.math.BigInteger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class BigIntegerMarshall
implements Marshall<BigInteger> {
    private ValueFactory vf;
    private URI datatype;

    public BigIntegerMarshall(ValueFactory vf) {
        this.vf = vf;
        this.datatype = XMLSchema.INTEGER;
    }

    @Override
    public String getJavaClassName() {
        return BigInteger.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI dt) {
        if (!dt.equals((Object)this.datatype)) {
            throw new IllegalArgumentException(dt.toString());
        }
    }

    @Override
    public BigInteger deserialize(Literal literal) {
        return literal.integerValue();
    }

    @Override
    public Literal serialize(BigInteger object) {
        return this.vf.createLiteral(object.toString(), this.datatype);
    }
}

