/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class BooleanMarshall
implements Marshall<Boolean> {
    private ValueFactory vf;

    public BooleanMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Boolean.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.BOOLEAN;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.BOOLEAN)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Boolean deserialize(Literal literal) {
        return literal.booleanValue();
    }

    @Override
    public Literal serialize(Boolean object) {
        return this.vf.createLiteral(object.booleanValue());
    }
}

