/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.exceptions.ObjectConversionException;
import org.openrdf.repository.object.managers.Marshall;

public class ByteArrayMarshall
implements Marshall<byte[]> {
    private ValueFactory vf;
    private URI datatype = XMLSchema.BASE64BINARY;

    public ByteArrayMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return byte[].class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public byte[] deserialize(Literal literal) {
        if (XMLSchema.HEXBINARY.equals((Object)literal.getDatatype())) {
            try {
                return Hex.decodeHex((char[])literal.stringValue().toCharArray());
            }
            catch (DecoderException e) {
                throw new ObjectConversionException(e);
            }
        }
        return Base64.decodeBase64((byte[])literal.stringValue().getBytes());
    }

    @Override
    public Literal serialize(byte[] data) {
        return this.vf.createLiteral(new String(Base64.encodeBase64((byte[])data)), this.datatype);
    }
}

