/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class ByteMarshall
implements Marshall<Byte> {
    private ValueFactory vf;

    public ByteMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Byte.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.BYTE;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.BYTE)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Byte deserialize(Literal literal) {
        return literal.byteValue();
    }

    @Override
    public Literal serialize(Byte object) {
        return this.vf.createLiteral(object.byteValue());
    }
}

