/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.managers.Marshall;

public class CharacterMarshall
implements Marshall<Character> {
    private static final String DATATYPE = "java:" + Character.class.getName();
    private ValueFactory vf;
    private URI datatype;

    public CharacterMarshall(ValueFactory vf) {
        this.vf = vf;
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return Character.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Character deserialize(Literal literal) {
        assert (literal.getLabel().length() == 1) : literal.getLabel();
        return Character.valueOf(literal.getLabel().charAt(0));
    }

    @Override
    public Literal serialize(Character object) {
        return this.vf.createLiteral(object.toString(), this.datatype);
    }
}

