/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import javax.xml.datatype.DatatypeConfigurationException;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.exceptions.ObjectConversionException;
import org.openrdf.repository.object.managers.Marshall;

public class ClassMarshall
implements Marshall<Class> {
    private static final String DATATYPE = "java:" + Class.class.getName();
    private ValueFactory vf;
    private ClassLoader cl;
    private URI datatype;

    public ClassMarshall(ValueFactory vf, ClassLoader cl) throws DatatypeConfigurationException {
        this.vf = vf;
        this.cl = cl;
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return Class.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class deserialize(Literal literal) {
        String label = literal.getLabel();
        try {
            ClassLoader classLoader = this.cl;
            synchronized (classLoader) {
                return Class.forName(label, true, this.cl);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ObjectConversionException(e);
        }
    }

    @Override
    public Literal serialize(Class object) {
        String label = object.getName();
        return this.vf.createLiteral(label, this.datatype);
    }
}

