/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.repository.object.exceptions.ObjectConversionException;
import org.openrdf.repository.object.managers.Marshall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentFragmentMarshall
implements Marshall<DocumentFragment> {
    private static final String TAG_NAME = "rdf-wrapper";
    private static final String END_TAG = "</rdf-wrapper>";
    private static final String START_TAG = "<rdf-wrapper>";
    private final DocumentBuilderFactory builder;
    private TransformerFactory factory = TransformerFactory.newInstance();
    private ValueFactory vf;
    private URI datatype = RDF.XMLLITERAL;
    private Class<? extends DocumentFragment> javaClass;

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(false);
        return factory;
    }

    public DocumentFragmentMarshall(ValueFactory vf) throws ParserConfigurationException {
        this.vf = vf;
        this.builder = DocumentFragmentMarshall.newDocumentBuilderFactory();
        Document doc = this.builder.newDocumentBuilder().newDocument();
        this.javaClass = doc.createDocumentFragment().getClass();
    }

    @Override
    public String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public DocumentFragment deserialize(Literal literal) {
        try {
            String wrapper = START_TAG + literal.getLabel() + END_TAG;
            StreamSource source = new StreamSource(new StringReader(wrapper));
            Document doc = this.builder.newDocumentBuilder().newDocument();
            DOMResult result = new DOMResult(doc);
            Transformer transformer = this.factory.newTransformer();
            ErrorCatcher listener = new ErrorCatcher();
            transformer.setErrorListener(listener);
            transformer.transform(source, result);
            if (listener.isFatal()) {
                throw listener.getFatalError();
            }
            DocumentFragment frag = doc.createDocumentFragment();
            Element element = doc.getDocumentElement();
            NodeList nodes = element.getChildNodes();
            int size = nodes.getLength();
            ArrayList<Node> list = new ArrayList<Node>(size);
            int n = size;
            for (int i = 0; i < n; ++i) {
                list.add(nodes.item(i));
            }
            for (Node node : list) {
                frag.appendChild(node);
            }
            return frag;
        }
        catch (TransformerConfigurationException e) {
            throw new ObjectConversionException(e);
        }
        catch (TransformerException e) {
            throw new ObjectConversionException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ObjectConversionException(e);
        }
    }

    @Override
    public Literal serialize(DocumentFragment object) {
        try {
            Document doc = this.builder.newDocumentBuilder().newDocument();
            Element wrapper = doc.createElement(TAG_NAME);
            wrapper.appendChild(doc.importNode(object, true));
            doc.appendChild(wrapper);
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer transformer = this.factory.newTransformer();
            ErrorCatcher listener = new ErrorCatcher();
            transformer.setErrorListener(listener);
            transformer.transform(source, result);
            if (listener.isFatal()) {
                throw listener.getFatalError();
            }
            String string = writer.toString();
            int l = START_TAG.length();
            int start = string.indexOf(START_TAG.substring(0, l - 1)) + l;
            int end = string.lastIndexOf(END_TAG);
            String label = string.substring(start, end);
            return this.vf.createLiteral(label, RDF.XMLLITERAL);
        }
        catch (TransformerConfigurationException e) {
            throw new ObjectConversionException(e);
        }
        catch (TransformerException e) {
            throw new ObjectConversionException(e);
        }
        catch (ParserConfigurationException e) {
            throw new ObjectConversionException(e);
        }
    }

    private static class ErrorCatcher
    implements ErrorListener {
        private Logger logger = LoggerFactory.getLogger(ErrorCatcher.class);
        private TransformerException fatal;

        private ErrorCatcher() {
        }

        public boolean isFatal() {
            return this.fatal != null;
        }

        public TransformerException getFatalError() {
            return this.fatal;
        }

        @Override
        public void error(TransformerException exception) {
            this.logger.warn(exception.toString(), (Throwable)exception);
        }

        @Override
        public void fatalError(TransformerException exception) {
            if (this.fatal == null) {
                this.fatal = exception;
            }
            this.logger.error(exception.toString(), (Throwable)exception);
        }

        @Override
        public void warning(TransformerException exception) {
            this.logger.info(exception.toString(), (Throwable)exception);
        }
    }
}

