/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class DoubleMarshall
implements Marshall<Double> {
    private ValueFactory vf;

    public DoubleMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Double.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.DOUBLE;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.DOUBLE)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Double deserialize(Literal literal) {
        return literal.doubleValue();
    }

    @Override
    public Literal serialize(Double object) {
        return this.vf.createLiteral(object.doubleValue());
    }
}

