/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class DurationMarshall
implements Marshall<Duration> {
    private ValueFactory vf;
    private DatatypeFactory factory;
    private Class<? extends Duration> javaClass;
    private URI datatype;

    public DurationMarshall(ValueFactory vf) throws DatatypeConfigurationException {
        this.vf = vf;
        this.factory = DatatypeFactory.newInstance();
        this.javaClass = this.factory.newDuration(0L).getClass();
        this.datatype = XMLSchema.DURATION;
    }

    @Override
    public String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Duration deserialize(Literal literal) {
        return this.factory.newDuration(literal.getLabel());
    }

    @Override
    public Literal serialize(Duration object) {
        return this.vf.createLiteral(object.toString(), this.datatype);
    }
}

