/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class FloatMarshall
implements Marshall<Float> {
    private ValueFactory vf;

    public FloatMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Float.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.FLOAT;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.FLOAT)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Float deserialize(Literal literal) {
        return Float.valueOf(literal.floatValue());
    }

    @Override
    public Literal serialize(Float object) {
        return this.vf.createLiteral(object.floatValue());
    }
}

