/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.managers.Marshall;

public class GregorianCalendarMarshall
implements Marshall<GregorianCalendar> {
    private static final String DATATYPE = "java:" + GregorianCalendar.class.getName();
    private ValueFactory vf;
    private DatatypeFactory factory;
    private URI datatype;

    public GregorianCalendarMarshall(ValueFactory vf) throws DatatypeConfigurationException {
        this.vf = vf;
        this.factory = DatatypeFactory.newInstance();
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return GregorianCalendar.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public GregorianCalendar deserialize(Literal literal) {
        String label = literal.getLabel();
        XMLGregorianCalendar gc = this.factory.newXMLGregorianCalendar(label);
        return gc.toGregorianCalendar();
    }

    @Override
    public Literal serialize(GregorianCalendar object) {
        String label = this.factory.newXMLGregorianCalendar(object).toXMLFormat();
        return this.vf.createLiteral(label, this.datatype);
    }
}

