/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class IntegerMarshall
implements Marshall<Integer> {
    private ValueFactory vf;

    public IntegerMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Integer.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.INT;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.INT)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Integer deserialize(Literal literal) {
        return literal.intValue();
    }

    @Override
    public Literal serialize(Integer object) {
        return this.vf.createLiteral(object.intValue());
    }
}

