/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.object.LangString;
import org.openrdf.repository.object.managers.Marshall;

public class LangStringMarshall<T>
implements Marshall<T> {
    private final ValueFactory vf;
    private final Class<T> type;
    private URI datatype;

    public LangStringMarshall(ValueFactory vf, Class<T> type) {
        this(vf, type, vf.createURI("http://www.w3.org/1999/02/22-rdf-syntax-ns#langString"));
    }

    public LangStringMarshall(ValueFactory vf, Class<T> type, URI datatype) {
        assert (type.isAssignableFrom(LangString.class));
        this.vf = vf;
        this.type = type;
        this.datatype = datatype;
    }

    @Override
    public String getJavaClassName() {
        return this.type.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public T deserialize(Literal literal) {
        String lang = literal.getLanguage();
        if (lang == null) {
            return this.type.cast(literal.getLabel());
        }
        return this.type.cast(new LangString(literal.getLabel(), lang));
    }

    @Override
    public Literal serialize(T text) {
        if (text instanceof LangString) {
            return this.vf.createLiteral(text.toString(), ((LangString)text).getLang());
        }
        return this.vf.createLiteral(text.toString());
    }
}

