/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class LocaleMarshall
implements Marshall<Locale> {
    private ValueFactory vf;
    private URI datatype;
    private ConcurrentMap<String, Locale> locales = new ConcurrentHashMap<String, Locale>();

    public LocaleMarshall(ValueFactory vf) {
        this.vf = vf;
        this.datatype = XMLSchema.LANGUAGE;
    }

    @Override
    public String getJavaClassName() {
        return Locale.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Locale deserialize(Literal literal) {
        String lang = literal.getLabel();
        Locale locale = (Locale)this.locales.get(lang);
        if (locale == null) {
            String[] l = lang.split("-", 3);
            String language = l.length < 1 ? "" : l[0];
            String country = l.length < 2 ? "" : l[1];
            String variant = l.length < 3 ? "" : l[2];
            locale = new Locale(language, country.toUpperCase(), variant);
            Locale o = this.locales.putIfAbsent(lang, locale);
            if (o != null) {
                locale = o;
            }
        }
        return locale;
    }

    @Override
    public Literal serialize(Locale object) {
        String label = object.toString().toLowerCase().replace('_', '-');
        return this.vf.createLiteral(label, this.datatype);
    }
}

