/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class LongMarshall
implements Marshall<Long> {
    private ValueFactory vf;

    public LongMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Long.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.LONG;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.LONG)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Long deserialize(Literal literal) {
        return literal.longValue();
    }

    @Override
    public Literal serialize(Long object) {
        return this.vf.createLiteral(object.longValue());
    }
}

