/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.lang.reflect.Constructor;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.exceptions.ObjectConversionException;
import org.openrdf.repository.object.managers.Marshall;

public class ObjectConstructorMarshall<T>
implements Marshall<T> {
    private ValueFactory vf;
    private Constructor<T> constructor;
    private URI datatype;

    public ObjectConstructorMarshall(ValueFactory vf, Class<T> type) throws NoSuchMethodException {
        this.vf = vf;
        ValueFactoryImpl uf = ValueFactoryImpl.getInstance();
        this.datatype = uf.createURI("java:", type.getName());
        try {
            this.constructor = type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            try {
                this.constructor = type.getConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException e1) {
                throw e;
            }
        }
    }

    @Override
    public String getJavaClassName() {
        return this.constructor.getDeclaringClass().getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public T deserialize(Literal literal) {
        try {
            return this.constructor.newInstance(literal.getLabel());
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    @Override
    public Literal serialize(T object) {
        return this.vf.createLiteral(object.toString(), this.datatype);
    }
}

