/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.exceptions.ObjectConversionException;
import org.openrdf.repository.object.managers.Marshall;

public class ObjectSerializationMarshall<T>
implements Marshall<T> {
    private static final String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
    private ValueFactory vf;
    private Class<T> type;
    private URI datatype;

    public ObjectSerializationMarshall(ValueFactory vf, Class<T> type) {
        this.vf = vf;
        this.type = type;
        this.datatype = ValueFactoryImpl.getInstance().createURI("java:", type.getName());
    }

    @Override
    public String getJavaClassName() {
        return this.type.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public T deserialize(Literal literal) {
        try {
            byte[] decoded = this.decode(literal.getLabel());
            ByteArrayInputStream is = new ByteArrayInputStream(decoded);
            ObjectInputStream ois = new ObjectInputStream(is);
            Object result = ois.readObject();
            ois.close();
            return this.type.cast(result);
        }
        catch (ObjectConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    @Override
    public Literal serialize(T object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            byte[] byteArray = bos.toByteArray();
            String label = this.encode(byteArray);
            return this.vf.createLiteral(label, this.datatype);
        }
        catch (ObjectConversionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectConversionException(e);
        }
    }

    private String encode(byte[] in) {
        StringBuilder out = new StringBuilder(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            byte ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        return out.toString();
    }

    private byte[] decode(String str) {
        char[] in = str.toCharArray();
        byte[] out = new byte[in.length / 2];
        if (in.length % 2 == 1) {
            throw new ObjectConversionException("Hex String must be an odd number of characters");
        }
        int j = 0;
        for (int i = 0; i < out.length; ++i) {
            int most = Character.digit(in[j++], 16);
            int least = Character.digit(in[j++], 16);
            int value = most << 4 | least;
            out[i] = (byte)(value & 0xFF);
        }
        return out;
    }
}

