/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.managers.Marshall;

public class PatternMarshall
implements Marshall<Pattern> {
    private static final String DATATYPE = "java:" + Pattern.class.getName();
    private ValueFactory vf;
    private URI datatype;

    public PatternMarshall(ValueFactory vf) {
        this.vf = vf;
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return Pattern.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Pattern deserialize(Literal literal) {
        return Pattern.compile(literal.getLabel());
    }

    @Override
    public Literal serialize(Pattern object) {
        return this.vf.createLiteral(object.toString(), this.datatype);
    }
}

