/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import javax.xml.namespace.QName;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class QNameMarshall
implements Marshall<QName> {
    private ValueFactory vf;

    public QNameMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return QName.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.QNAME;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.QNAME)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public QName deserialize(Literal literal) {
        String label = literal.getLabel();
        int idx = label.indexOf(58);
        if (label.charAt(0) == '{' || idx < 0) {
            return QName.valueOf(label);
        }
        String prefix = label.substring(0, idx);
        return new QName("", label.substring(idx + 1), prefix);
    }

    @Override
    public Literal serialize(QName object) {
        if (object.getPrefix().length() == 0) {
            return this.vf.createLiteral(object.toString());
        }
        StringBuilder label = new StringBuilder();
        label.append(object.getPrefix());
        label.append(":");
        label.append(object.getLocalPart());
        return this.vf.createLiteral(label.toString());
    }
}

