/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class ShortMarshall
implements Marshall<Short> {
    private ValueFactory vf;

    public ShortMarshall(ValueFactory vf) {
        this.vf = vf;
    }

    @Override
    public String getJavaClassName() {
        return Short.class.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.SHORT;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (!datatype.equals((Object)XMLSchema.SHORT)) {
            throw new IllegalArgumentException(datatype.toString());
        }
    }

    @Override
    public Short deserialize(Literal literal) {
        return literal.shortValue();
    }

    @Override
    public Literal serialize(Short object) {
        return this.vf.createLiteral(object.shortValue());
    }
}

