/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.sql.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.managers.Marshall;

public class SqlDateMarshall
implements Marshall<Date> {
    private static final String DATATYPE = "java:" + Date.class.getName();
    private ValueFactory vf;
    private DatatypeFactory factory;
    private URI datatype;

    public SqlDateMarshall(ValueFactory vf) throws DatatypeConfigurationException {
        this.vf = vf;
        this.factory = DatatypeFactory.newInstance();
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return Date.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Date deserialize(Literal literal) {
        String label = literal.getLabel();
        XMLGregorianCalendar gc = this.factory.newXMLGregorianCalendar(label);
        return new Date(gc.toGregorianCalendar().getTimeInMillis());
    }

    @Override
    public Literal serialize(Date object) {
        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
        gc.setTime(object);
        String label = this.factory.newXMLGregorianCalendar(gc).toXMLFormat();
        return this.vf.createLiteral(label, this.datatype);
    }
}

