/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.sql.Time;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.managers.Marshall;

public class SqlTimeMarshall
implements Marshall<Time> {
    private static final String DATATYPE = "java:" + Time.class.getName();
    private ValueFactory vf;
    private DatatypeFactory factory;
    private URI datatype;

    public SqlTimeMarshall(ValueFactory vf) throws DatatypeConfigurationException {
        this.vf = vf;
        this.factory = DatatypeFactory.newInstance();
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return Time.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Time deserialize(Literal literal) {
        String label = literal.getLabel();
        XMLGregorianCalendar gc = this.factory.newXMLGregorianCalendar(label);
        return new Time(gc.toGregorianCalendar().getTimeInMillis());
    }

    @Override
    public Literal serialize(Time object) {
        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
        gc.setTime(object);
        String label = this.factory.newXMLGregorianCalendar(gc).toXMLFormat();
        return this.vf.createLiteral(label, this.datatype);
    }
}

