/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.object.managers.Marshall;

public class SqlTimestampMarshall
implements Marshall<Timestamp> {
    private static final String DATATYPE = "java:" + Timestamp.class.getName();
    private ValueFactory vf;
    private DatatypeFactory factory;
    private URI datatype;

    public SqlTimestampMarshall(ValueFactory vf) throws DatatypeConfigurationException {
        this.vf = vf;
        this.factory = DatatypeFactory.newInstance();
        this.datatype = ValueFactoryImpl.getInstance().createURI(DATATYPE);
    }

    @Override
    public String getJavaClassName() {
        return Timestamp.class.getName();
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Timestamp deserialize(Literal literal) {
        String label = literal.getLabel();
        XMLGregorianCalendar gc = this.factory.newXMLGregorianCalendar(label);
        return new Timestamp(gc.toGregorianCalendar().getTimeInMillis());
    }

    @Override
    public Literal serialize(Timestamp object) {
        GregorianCalendar gc = new GregorianCalendar(0, 0, 0);
        gc.setTime(object);
        XMLGregorianCalendar xgc = this.factory.newXMLGregorianCalendar(gc);
        BigDecimal fraction = BigDecimal.valueOf(object.getNanos(), 9);
        xgc.setFractionalSecond(fraction);
        String label = xgc.toXMLFormat();
        return this.vf.createLiteral(label, this.datatype);
    }
}

