/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.object.managers.Marshall;

public class StringMarshall
implements Marshall<Object> {
    private ValueFactory vf;
    private String className;
    private URI datatype;

    public StringMarshall(ValueFactory vf) {
        this(vf, String.class.getName());
    }

    public StringMarshall(ValueFactory vf, String className) {
        this.vf = vf;
        this.className = className;
    }

    public StringMarshall(ValueFactory vf, String className, URI datatype) {
        this(vf, className);
        this.datatype = datatype;
    }

    @Override
    public String getJavaClassName() {
        return this.className;
    }

    @Override
    public URI getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(URI datatype) {
        this.datatype = datatype;
    }

    @Override
    public Object deserialize(Literal literal) {
        return literal.getLabel();
    }

    @Override
    public Literal serialize(Object object) {
        return this.vf.createLiteral(object.toString());
    }
}

