/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.converters;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.repository.object.managers.Marshall;

public class XMLGregorianCalendarMarshall
implements Marshall<XMLGregorianCalendar> {
    private ValueFactory vf;
    private Class<? extends XMLGregorianCalendar> javaClass;

    public XMLGregorianCalendarMarshall(ValueFactory vf) throws DatatypeConfigurationException {
        this.vf = vf;
        DatatypeFactory factory = DatatypeFactory.newInstance();
        this.javaClass = factory.newXMLGregorianCalendar().getClass();
    }

    @Override
    public String getJavaClassName() {
        return this.javaClass.getName();
    }

    @Override
    public URI getDatatype() {
        return XMLSchema.DATETIME;
    }

    @Override
    public void setDatatype(URI datatype) {
        if (datatype.equals((Object)XMLSchema.DATETIME)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.DATE)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.TIME)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.GYEARMONTH)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.GMONTHDAY)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.GYEAR)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.GMONTH)) {
            return;
        }
        if (datatype.equals((Object)XMLSchema.GDAY)) {
            return;
        }
        throw new IllegalArgumentException(datatype.toString());
    }

    @Override
    public XMLGregorianCalendar deserialize(Literal literal) {
        return literal.calendarValue();
    }

    @Override
    public Literal serialize(XMLGregorianCalendar object) {
        return this.vf.createLiteral(object);
    }
}

