/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Matching;

public class CheckForConcept {
    protected ClassLoader cl;

    public CheckForConcept(ClassLoader cl) {
        this.cl = cl;
    }

    public String getName() {
        return "concepts";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName(String name, InputStream stream) throws IOException {
        DataInputStream dstream = new DataInputStream(stream);
        try {
            ClassFile cf = new ClassFile(dstream);
            if (this.checkAccessFlags(cf.getAccessFlags()) && this.isAnnotationPresent(cf)) {
                String string = cf.getName();
                return string;
            }
        }
        finally {
            dstream.close();
        }
        return null;
    }

    protected boolean checkAccessFlags(int flags) {
        return (flags & 0x2000) == 0;
    }

    protected boolean isAnnotationPresent(ClassFile cf) {
        AnnotationsAttribute attr = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        return this.isAnnotationPresent(attr);
    }

    protected boolean isAnnotationPresent(AnnotationsAttribute attr) {
        Annotation[] annotations;
        if (attr != null && (annotations = attr.getAnnotations()) != null) {
            for (Annotation ann : annotations) {
                if (ann.getTypeName().equals(Iri.class.getName())) {
                    return true;
                }
                if (!ann.getTypeName().equals(Matching.class.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

