/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class DirUtil {
    static final Collection<File> temporary = new ArrayList<File>();

    public static File createTempDir(String prefix) throws IOException {
        File tmpDir;
        String tmpDirStr = System.getProperty("java.io.tmpdir");
        if (tmpDirStr == null) {
            tmpDirStr = "tmp";
        }
        if (!(tmpDir = new File(tmpDirStr)).exists()) {
            tmpDir.mkdirs();
        }
        File dir = File.createTempFile(prefix, "", tmpDir);
        dir.delete();
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOnExit(File dir) {
        Collection<File> collection = temporary;
        synchronized (collection) {
            if (temporary.isEmpty()) {
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Collection<File> collection = temporary;
                        synchronized (collection) {
                            for (File dir : temporary) {
                                DirUtil.deleteFileOrDir(dir, 256);
                            }
                        }
                    }
                }, "Temporary Directory Cleanup"));
            }
            temporary.add(dir);
        }
    }

    static void deleteFileOrDir(File dir, int max) {
        File[] listFiles = dir.listFiles();
        if (listFiles != null && max > 0) {
            for (File file : listFiles) {
                DirUtil.deleteFileOrDir(file, max - 1);
            }
        }
        dir.delete();
    }
}

