/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;

public class DirectMapper
implements Cloneable {
    private Map<Class<?>, Set<URI>> directTypes = new HashMap(256);
    private Map<URI, Set<Class<?>>> directRoles = new HashMap(256);

    public DirectMapper clone() {
        try {
            DirectMapper cloned = (DirectMapper)super.clone();
            cloned.directTypes = this.clone(this.directTypes);
            cloned.directRoles = this.clone(this.directRoles);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <K, V> Map<K, Set<V>> clone(Map<K, Set<V>> map) {
        HashMap<K, Set<V>> cloned = new HashMap<K, Set<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new HashSet((Collection)entry.getValue()));
        }
        return cloned;
    }

    public Set<Class<?>> getDirectRoles(URI type) {
        return this.directRoles.get(type);
    }

    public Set<URI> getDirectTypes(Class<?> role) {
        return this.directTypes.get(role);
    }

    public void recordRole(Class<?> role, URI rdfType) {
        Set<URI> set = this.directTypes.get(role);
        if (set == null) {
            set = new HashSet<URI>();
            this.directTypes.put(role, set);
        }
        if (rdfType != null) {
            set.add(rdfType);
        }
        if (rdfType != null) {
            Set<Class<?>> set1 = this.directRoles.get(rdfType);
            if (set1 == null) {
                set1 = new HashSet();
                this.directRoles.put(rdfType, set1);
            }
            if (role != null) {
                set1.add(role);
            }
        }
    }
}

