/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.object.exceptions.ObjectCompositionException;
import org.openrdf.repository.object.managers.helpers.DirectMapper;
import org.openrdf.repository.object.managers.helpers.SimpleRoleMapper;
import org.openrdf.repository.object.managers.helpers.TypeMapper;

public class HierarchicalRoleMapper
implements Cloneable {
    private DirectMapper directMapper = new DirectMapper();
    private TypeMapper typeMapper = new TypeMapper();
    private SimpleRoleMapper simpleRoleMapper = new SimpleRoleMapper();
    private Map<Class<?>, Set<Class<?>>> subclasses = new HashMap(256);

    public HierarchicalRoleMapper clone() {
        try {
            HierarchicalRoleMapper cloned = (HierarchicalRoleMapper)super.clone();
            cloned.directMapper = this.directMapper.clone();
            cloned.typeMapper = this.typeMapper.clone();
            cloned.simpleRoleMapper = this.simpleRoleMapper.clone();
            cloned.subclasses = this.clone(this.subclasses);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <K, V> Map<K, Set<V>> clone(Map<K, Set<V>> map) {
        HashMap<K, Set<V>> cloned = new HashMap<K, Set<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new HashSet((Collection)entry.getValue()));
        }
        return cloned;
    }

    public void setURIFactory(ValueFactory vf) {
        this.simpleRoleMapper.setURIFactory(vf);
    }

    public Collection<Class<?>> findAllRoles() {
        return this.simpleRoleMapper.findAllRoles();
    }

    public Collection<Class<?>> findRoles(URI type) {
        return this.simpleRoleMapper.findRoles(type);
    }

    public Collection<Class<?>> findRoles(Collection<URI> types, Collection<Class<?>> classes) {
        return this.simpleRoleMapper.findRoles(types, classes);
    }

    public boolean isNamedTypePresent() {
        return this.simpleRoleMapper.isNamedTypePresent();
    }

    public boolean isTypeRecorded(URI type) {
        return this.simpleRoleMapper.isTypeRecorded(type);
    }

    public URI findType(Class<?> role) {
        return this.typeMapper.findType(role);
    }

    public Collection<URI> findSubTypes(Class<?> role, Collection<URI> rdfTypes) {
        URI type = this.findType(role);
        if (type == null) {
            throw new ObjectCompositionException("Concept not registered: " + role.getSimpleName());
        }
        rdfTypes.add(type);
        Set<Class<?>> subset = this.subclasses.get(role);
        if (subset == null) {
            return rdfTypes;
        }
        for (Class<?> c : subset) {
            this.findSubTypes(c, rdfTypes);
        }
        return rdfTypes;
    }

    public synchronized void recordConcept(Class<?> role, URI type, boolean equiv, boolean primary) {
        assert (type != null);
        this.recordClassHierarchy(role);
        if (primary) {
            this.typeMapper.recordRole(role, type);
        }
        if (equiv) {
            this.directMapper.recordRole(role, type);
        }
        if (this.simpleRoleMapper.getBaseType().equals((Object)type)) {
            this.simpleRoleMapper.recordBaseRole(role);
        } else {
            Set<Class<?>> superRoles = this.getSuperRoles(role);
            HashSet newRoles = new HashSet(superRoles.size() + 1);
            newRoles.addAll(superRoles);
            newRoles.add(role);
            this.recordSubclasses(type, newRoles);
        }
    }

    public synchronized void recordBehaviour(Class<?> role, URI type, boolean equiv) {
        assert (type != null);
        if (equiv) {
            this.directMapper.recordRole(role, type);
        }
        if (this.simpleRoleMapper.getBaseType().equals((Object)type)) {
            this.recordClassHierarchy(role);
            this.simpleRoleMapper.recordBaseRole(role);
        } else {
            HashSet newRoles = new HashSet();
            newRoles.add(role);
            this.recordSubclasses(type, newRoles);
        }
    }

    private void recordClassHierarchy(Class<?> concept) {
        for (Class<?> sup : concept.getInterfaces()) {
            Set<Class<?>> set = this.subclasses.get(sup);
            if (set == null) {
                set = new HashSet();
                this.subclasses.put(sup, set);
            }
            if (set.contains(concept)) continue;
            set.add(concept);
            this.recordClassHierarchy(sup);
        }
        Class<?> sup = concept.getSuperclass();
        if (sup != null) {
            Set<Class<?>> set = this.subclasses.get(sup);
            if (set == null) {
                set = new HashSet();
                this.subclasses.put(sup, set);
            }
            if (!set.contains(concept)) {
                set.add(concept);
                this.recordClassHierarchy(sup);
            }
        }
    }

    private Set<Class<?>> getSuperRoles(Class<?> role) {
        HashSet superRoles = new HashSet();
        for (Class<?> sup : role.getInterfaces()) {
            Set<Class<?>> sr = this.getSuperRoles(sup);
            this.addRelatedRoles(sr, sup, superRoles);
        }
        Class<?> sup = role.getSuperclass();
        if (sup != null) {
            Set<Class<?>> sr = this.getSuperRoles(sup);
            this.addRelatedRoles(sr, sup, superRoles);
        }
        return superRoles;
    }

    private void recordSubclasses(URI type, Set<Class<?>> newRoles) {
        newRoles = this.simpleRoleMapper.recordRoles(newRoles, type);
        Set<Class<?>> directRoles = this.directMapper.getDirectRoles(type);
        if (directRoles != null) {
            for (Class<?> r : directRoles) {
                this.addRolesInSubclasses(r, newRoles);
            }
        }
    }

    private void addRolesInSubclasses(Class<?> role, Set<Class<?>> newRoles) {
        Set<Class<?>> subset = this.subclasses.get(role);
        if (subset == null) {
            return;
        }
        for (Class<?> sub : subset) {
            Set<Class<?>> subRoles = new HashSet();
            subRoles = this.addRelatedRoles(newRoles, sub, subRoles);
            this.addRolesInSubclasses(sub, subRoles);
        }
    }

    private Set<Class<?>> addRelatedRoles(Set<Class<?>> existing, Class<?> role, Set<Class<?>> roles) {
        roles.addAll(existing);
        Set<URI> set = this.directMapper.getDirectTypes(role);
        if (set != null) {
            for (URI uri : set) {
                this.simpleRoleMapper.recordRoles(existing, uri);
                for (Class<?> c : this.simpleRoleMapper.findRoles(uri)) {
                    roles.add(c);
                }
            }
        }
        return roles;
    }
}

