/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.openrdf.annotations.Iri;
import org.openrdf.annotations.Matching;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.repository.object.exceptions.ObjectStoreConfigException;
import org.openrdf.repository.object.managers.RoleMapper;
import org.openrdf.repository.object.managers.helpers.CheckForAnnotation;
import org.openrdf.repository.object.managers.helpers.CheckForBehaviour;
import org.openrdf.repository.object.managers.helpers.CheckForConcept;
import org.openrdf.repository.object.managers.helpers.DirectMapper;
import org.openrdf.repository.object.managers.helpers.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleClassLoader {
    private static final String CONCEPTS = "META-INF/org.openrdf.concepts";
    private static final String BEHAVIOURS = "META-INF/org.openrdf.behaviours";
    private static final String ANNOTATIONS = "META-INF/org.openrdf.annotations";
    private final Logger logger = LoggerFactory.getLogger(DirectMapper.class);
    private RoleMapper roleMapper;

    public RoleClassLoader(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
    }

    public void loadRoles(ClassLoader cl) throws ObjectStoreConfigException {
        try {
            ClassLoader first = RoleClassLoader.class.getClassLoader();
            Set<URL> loaded = this.load(new CheckForAnnotation(first), first, "annotations", ANNOTATIONS, true, new HashSet<URL>());
            loaded = this.load(new CheckForAnnotation(cl), cl, "annotations", ANNOTATIONS, true, loaded);
            loaded = this.load(new CheckForConcept(first), first, "concepts", CONCEPTS, true, new HashSet<URL>());
            loaded = this.load(new CheckForConcept(cl), cl, "concepts", CONCEPTS, true, loaded);
            loaded = this.load(new CheckForBehaviour(first), first, "behaviours", BEHAVIOURS, false, new HashSet<URL>());
            Set<URL> set = this.load(new CheckForBehaviour(cl), cl, "behaviours", BEHAVIOURS, false, loaded);
        }
        catch (ObjectStoreConfigException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectStoreConfigException(e);
        }
    }

    public void scan(URL jar, ClassLoader cl) throws ObjectStoreConfigException {
        this.scan(jar, new CheckForAnnotation(cl), ANNOTATIONS, cl);
        this.scan(jar, new CheckForConcept(cl), CONCEPTS, cl);
        this.scan(jar, new CheckForBehaviour(cl), BEHAVIOURS, cl);
    }

    private void scan(URL url, CheckForConcept checker, String role, ClassLoader cl) throws ObjectStoreConfigException {
        try {
            Scanner scanner = new Scanner(checker);
            this.load(scanner.scan(url, checker.getName(), role), cl, false);
        }
        catch (Exception e) {
            throw new ObjectStoreConfigException(e);
        }
    }

    private Set<URL> load(CheckForConcept checker, ClassLoader cl, String forType, String roles, boolean concept, Set<URL> exclude) throws IOException, ClassNotFoundException, ObjectStoreConfigException {
        if (cl == null) {
            return exclude;
        }
        Scanner scanner = new Scanner(checker, roles);
        Enumeration<URL> resources = cl.getResources(roles);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (exclude.contains(url)) continue;
            exclude.add(url);
            this.logger.debug("Reading roles from {}", (Object)url);
            try {
                Properties p = new Properties();
                p.load(url.openStream());
                if (p.isEmpty()) {
                    this.load(scanner.scan(url, forType, null), cl, concept);
                    continue;
                }
                this.load(p, cl, concept);
            }
            catch (IOException e) {
                String msg = e.getMessage() + " in: " + url;
                throw new ObjectStoreConfigException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = e.getMessage() + " in: " + url;
                throw new ObjectStoreConfigException(msg, e);
            }
        }
        return exclude;
    }

    private void load(List<String> roles, ClassLoader cl, boolean concept) throws IOException, ObjectStoreConfigException {
        for (String role : roles) {
            try {
                Class<?> clazz = this.forName(role, true, cl);
                this.recordRole(clazz, null, concept);
            }
            catch (ClassNotFoundException exc) {
                this.logger.error(exc.toString());
            }
        }
    }

    private void load(Properties p, ClassLoader cl, boolean concept) throws ClassNotFoundException, IOException, ObjectStoreConfigException {
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String role = (String)e.getKey();
            String types = (String)e.getValue();
            try {
                int idx = role.indexOf(35);
                if (idx >= 0) {
                    role = role.substring(0, idx);
                }
                Class<?> clazz = this.forName(role, true, cl);
                for (String rdf : types.split("\\s+")) {
                    if (idx < 0) {
                        this.recordRole(clazz, rdf, concept);
                        continue;
                    }
                    String mname = ((String)e.getKey()).substring(idx + 1);
                    if (mname.endsWith("()")) {
                        mname = mname.substring(0, mname.length() - 2);
                    }
                    if (rdf.length() > 0) {
                        this.roleMapper.addAnnotation(clazz.getMethod(mname, new Class[0]), (URI)new URIImpl(rdf));
                        continue;
                    }
                    this.roleMapper.addAnnotation(clazz.getMethod(mname, new Class[0]));
                }
            }
            catch (ClassNotFoundException exc) {
                this.logger.error(exc.toString());
            }
            catch (NoSuchMethodException exc) {
                this.logger.error(exc.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> forName(String name, boolean init, ClassLoader cl) throws ClassNotFoundException {
        ClassLoader classLoader = cl;
        synchronized (classLoader) {
            return Class.forName(name, init, cl);
        }
    }

    private void recordRole(Class<?> clazz, String uri, boolean concept) throws ObjectStoreConfigException {
        if (uri == null || uri.length() == 0) {
            if (clazz.isAnnotation()) {
                this.roleMapper.addAnnotation(clazz);
            } else if (this.isAnnotationPresent(clazz) || concept) {
                this.roleMapper.addConcept(clazz);
            } else {
                this.roleMapper.addBehaviour(clazz);
            }
        } else if (clazz.isAnnotation()) {
            this.roleMapper.addAnnotation(clazz, (URI)new URIImpl(uri));
        } else if (this.isAnnotationPresent(clazz) || concept) {
            this.roleMapper.addConcept(clazz, (URI)new URIImpl(uri));
        } else {
            this.roleMapper.addBehaviour(clazz, (URI)new URIImpl(uri));
        }
    }

    private boolean isAnnotationPresent(Class<?> clazz) {
        for (Annotation ann : clazz.getAnnotations()) {
            String name = ann.annotationType().getName();
            if (Iri.class.getName().equals(name)) {
                return true;
            }
            if (!Matching.class.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

