/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RoleMatcher
implements Cloneable {
    private Comparator<String> reverse = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            int i = o1.length();
            int j = o2.length();
            while (i > 0 && j > 0) {
                char c2;
                char c1;
                if ((c1 = o1.charAt(--i)) == (c2 = o2.charAt(--j))) continue;
                return c1 - c2;
            }
            return i - j;
        }
    };
    private ConcurrentNavigableMap<String, ConcurrentNavigableMap<String, Collection<Class<?>>>> hostsufPathpre = new ConcurrentSkipListMap(this.reverse);
    private ConcurrentNavigableMap<String, ConcurrentMap<String, Collection<Class<?>>>> hostsufPath = new ConcurrentSkipListMap(this.reverse);
    private ConcurrentNavigableMap<String, Collection<Class<?>>> uriprefix = new ConcurrentSkipListMap();
    private ConcurrentMap<String, Collection<Class<?>>> uris = new ConcurrentHashMap();
    private boolean empty = true;

    public RoleMatcher clone() {
        RoleMatcher cloned = new RoleMatcher();
        for (String host : this.hostsufPathpre.keySet()) {
            for (String path : ((ConcurrentNavigableMap)this.hostsufPathpre.get(host)).keySet()) {
                for (Class role : (Collection)((ConcurrentNavigableMap)this.hostsufPathpre.get(host)).get(path)) {
                    cloned.addRoles('*' + host + path + '*', role);
                }
            }
        }
        for (String host : this.hostsufPath.keySet()) {
            for (String path : ((ConcurrentMap)this.hostsufPath.get(host)).keySet()) {
                for (Class role : (Collection)((ConcurrentMap)this.hostsufPath.get(host)).get(path)) {
                    cloned.addRoles('*' + host + path, role);
                }
            }
        }
        for (String key : this.uriprefix.keySet()) {
            for (Class role : (Collection)this.uriprefix.get(key)) {
                cloned.addRoles(key + '*', role);
            }
        }
        for (String key : this.uris.keySet()) {
            for (Class role : (Collection)this.uris.get(key)) {
                cloned.addRoles(key, role);
            }
        }
        return cloned;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void addRoles(String pattern, Class<?> role) {
        if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            if (prefix.startsWith("/")) {
                this.addPathPrefix(this.hostsufPathpre, "", prefix, role);
            } else if (prefix.startsWith("*") && prefix.contains("/")) {
                int idx = prefix.indexOf(47);
                String suffix = prefix.substring(1, idx);
                prefix = prefix.substring(idx);
                this.addPathPrefix(this.hostsufPathpre, suffix, prefix, role);
            } else if (prefix.startsWith("*")) {
                String suffix = prefix.substring(1);
                this.addPathPrefix(this.hostsufPathpre, suffix, "", role);
            } else {
                this.add(this.uriprefix, prefix, role);
            }
        } else if (pattern.startsWith("/")) {
            this.addPath(this.hostsufPath, "", pattern, role);
        } else if (pattern.startsWith("*") && pattern.contains("/")) {
            int idx = pattern.indexOf(47);
            String suffix = pattern.substring(1, idx);
            pattern = pattern.substring(idx);
            this.addPath(this.hostsufPath, suffix, pattern, role);
        } else if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1);
            this.addPath(this.hostsufPath, suffix, "", role);
        } else {
            this.add(this.uris, pattern, role);
        }
        this.empty = false;
    }

    public void findRoles(String uri, Collection<Class<?>> roles) {
        this.findExactRoles(this.uris, uri, roles);
        this.findRoles(this.uriprefix, uri, roles);
        int idx = uri.indexOf("://") + 3;
        if (idx > 3 && idx < uri.length()) {
            int sidx = uri.indexOf(47, idx);
            if (sidx > 0) {
                String auth = uri.substring(idx, sidx);
                String path = uri.substring(sidx);
                this.findPathPrefixRoles(auth, path, roles);
                this.findPathRoles(auth, path, roles);
            } else {
                String auth = uri.substring(idx);
                this.findPathPrefixRoles(auth, "", roles);
                this.findPathRoles(auth, "", roles);
            }
        }
    }

    private void addPathPrefix(ConcurrentNavigableMap<String, ConcurrentNavigableMap<String, Collection<Class<?>>>> map, String suffix, String prefix, Class<?> role) {
        ConcurrentNavigableMap o;
        ConcurrentNavigableMap<String, Collection<Class<Object>>> m = (ConcurrentSkipListMap)map.get(suffix);
        if (m == null && (o = (ConcurrentNavigableMap)map.putIfAbsent(suffix, m = new ConcurrentSkipListMap())) != null) {
            m = o;
        }
        this.add(m, prefix, role);
    }

    private void addPath(ConcurrentNavigableMap<String, ConcurrentMap<String, Collection<Class<?>>>> map, String suffix, String prefix, Class<?> role) {
        ConcurrentMap o;
        ConcurrentMap<String, Collection<Class<Object>>> m = (ConcurrentHashMap)map.get(suffix);
        if (m == null && (o = (ConcurrentMap)map.putIfAbsent(suffix, m = new ConcurrentHashMap())) != null) {
            m = o;
        }
        this.add(m, prefix, role);
    }

    private void add(ConcurrentMap<String, Collection<Class<?>>> map, String pattern, Class<?> role) {
        Collection o;
        Collection<Class<Object>> list = (CopyOnWriteArrayList)map.get(pattern);
        if (list == null && (o = (Collection)map.putIfAbsent(pattern, list = new CopyOnWriteArrayList())) != null) {
            list = o;
        }
        if (!list.contains(role)) {
            list.add(role);
        }
    }

    private void findPathRoles(String auth, String path, Collection<Class<?>> roles) {
        String key;
        Map map = (Map)this.hostsufPath.get(auth);
        if (map != null) {
            this.findExactRoles(map, path, roles);
        }
        if ((key = this.hostsufPath.lowerKey(auth)) == null) {
            return;
        }
        if (auth.endsWith(key)) {
            this.findPathRoles(key, path, roles);
        } else if (auth.length() > 0) {
            int i = auth.length() - 1;
            for (int j = key.length() - 1; i >= 0 && j >= 0 && auth.charAt(i) == key.charAt(j); --i, --j) {
            }
            String suffix = auth.substring(i + 1);
            this.findPathRoles(suffix, path, roles);
        }
    }

    private void findPathPrefixRoles(String auth, String path, Collection<Class<?>> roles) {
        String key;
        NavigableMap map = (NavigableMap)this.hostsufPathpre.get(auth);
        if (map != null) {
            this.findRoles(map, path, roles);
        }
        if ((key = this.hostsufPathpre.lowerKey(auth)) == null) {
            return;
        }
        if (auth.endsWith(key)) {
            this.findPathPrefixRoles(key, path, roles);
        } else if (auth.length() > 0) {
            int i = auth.length() - 1;
            for (int j = key.length() - 1; i >= 0 && j >= 0 && auth.charAt(i) == key.charAt(j); --i, --j) {
            }
            String suffix = auth.substring(i + 1);
            this.findPathPrefixRoles(suffix, path, roles);
        }
    }

    private void findRoles(NavigableMap<String, Collection<Class<?>>> map, String full, Collection<Class<?>> roles) {
        this.findExactRoles(map, full, roles);
        String key = map.lowerKey(full);
        if (key == null) {
            return;
        }
        if (full.startsWith(key)) {
            this.findRoles(map, key, roles);
        } else if (full.length() > 0) {
            int idx;
            for (idx = 0; idx < full.length() && idx < key.length() && full.charAt(idx) == key.charAt(idx); ++idx) {
            }
            String prefix = full.substring(0, idx);
            this.findRoles(map, prefix, roles);
        }
    }

    private void findExactRoles(Map<String, Collection<Class<?>>> map, String uri, Collection<Class<?>> roles) {
        Collection<Class<?>> list = map.get(uri);
        if (list != null) {
            roles.addAll(list);
        }
    }
}

