/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openrdf.repository.object.managers.helpers.CheckForConcept;
import org.openrdf.repository.object.managers.helpers.HierarchicalRoleMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scanner {
    private final Logger logger = LoggerFactory.getLogger(HierarchicalRoleMapper.class);
    private String resource;
    private CheckForConcept checker;

    public Scanner(CheckForConcept checker) {
        this(checker, null);
    }

    public Scanner(CheckForConcept checker, String resource) {
        this.checker = checker;
        this.resource = resource;
    }

    public List<String> scan(URL url, String forType, String marker) throws IOException {
        String urlPath = URLDecoder.decode(url.getFile(), "UTF-8");
        if (this.resource != null) {
            assert (urlPath.endsWith(this.resource));
            urlPath = urlPath.substring(0, urlPath.length() - this.resource.length());
        }
        if (urlPath.startsWith("file:")) {
            urlPath = urlPath.substring(5);
        }
        if (urlPath.lastIndexOf(33) > 0) {
            urlPath = urlPath.substring(0, urlPath.lastIndexOf(33));
        }
        ArrayList<String> roles = new ArrayList<String>();
        File file = new File(urlPath);
        if (file.isDirectory()) {
            if (!this.exists(file, marker)) {
                this.logger.info("Scanning {} for {}", (Object)file, (Object)forType);
                roles.addAll(this.scanDirectory(file, null, 256));
            }
        } else {
            ZipFile zip = new ZipFile(file);
            if (!this.exists(zip, marker)) {
                this.logger.info("Scanning {} for {}", (Object)file, (Object)forType);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String name;
                    ZipEntry entry = entries.nextElement();
                    String ename = entry.getName();
                    if (!ename.endsWith(".class") || ename.contains("-") || (name = this.getClassName(ename, zip.getInputStream(entry))) == null) continue;
                    roles.add(name);
                }
            }
        }
        return roles;
    }

    private boolean exists(ZipFile zip, String marker) {
        if (marker == null) {
            return false;
        }
        return zip.getEntry(marker) != null;
    }

    private boolean exists(File file, String marker) {
        if (marker == null) {
            return false;
        }
        return new File(file, marker).exists();
    }

    private List<String> scanDirectory(File file, String path, int max) throws IOException {
        if (max < 0) {
            throw new AssertionError((Object)("Recursive Path: " + file));
        }
        ArrayList<String> roles = new ArrayList<String>();
        for (File child : file.listFiles()) {
            String name;
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                roles.addAll(this.scanDirectory(child, newPath, max - 1));
                continue;
            }
            if (!newPath.endsWith(".class") || newPath.contains("-") || (name = this.getClassName(newPath, new FileInputStream(child))) == null) continue;
            roles.add(name);
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getClassName(String name, InputStream in) throws IOException {
        try {
            String string = this.checker.getClassName(name, in);
            return string;
        }
        catch (Exception e) {
            this.logger.warn("Cannot decode {}", (Object)name);
            this.logger.debug("Cannot decode " + name, (Throwable)e);
        }
        finally {
            in.close();
        }
        return null;
    }
}

