/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRoleMapper
implements Cloneable {
    private static final String BASE_TYPE = "http://www.w3.org/2000/01/rdf-schema#Resource";
    private final Logger logger = LoggerFactory.getLogger(SimpleRoleMapper.class);
    private URI baseType;
    private boolean empty = true;
    private Map<URI, List<Class<?>>> roles;
    private Map<URI, Boolean> unregisteredTypes = new ConcurrentHashMap<URI, Boolean>();

    public SimpleRoleMapper() {
        this.roles = new ConcurrentHashMap(256);
    }

    public SimpleRoleMapper clone() {
        try {
            SimpleRoleMapper cloned = (SimpleRoleMapper)super.clone();
            cloned.roles = this.clone(this.roles);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private <K, V> Map<K, List<V>> clone(Map<K, List<V>> map) {
        HashMap<K, List<V>> cloned = new HashMap<K, List<V>>(map);
        for (Map.Entry entry : cloned.entrySet()) {
            entry.setValue(new ArrayList((Collection)entry.getValue()));
        }
        return cloned;
    }

    public void setURIFactory(ValueFactory vf) {
        this.baseType = vf.createURI(BASE_TYPE);
        List list = Collections.emptyList();
        this.roles.put(this.baseType, list);
    }

    public URI getBaseType() {
        return this.baseType;
    }

    public Collection<Class<?>> findAllRoles() {
        ArrayList list = new ArrayList(this.roles.size());
        for (List<Class<?>> v : this.roles.values()) {
            list.addAll(v);
        }
        return list;
    }

    public Collection<Class<?>> findRoles(URI type) {
        List<Class<?>> classes = this.roles.get(type);
        if (classes == null) {
            this.unregistered(type);
            return this.findBaseRoles();
        }
        return classes;
    }

    public Collection<Class<?>> findRoles(Collection<URI> types, Collection<Class<?>> classes) {
        boolean found = false;
        for (URI type : types) {
            List<Class<?>> javaClass = this.roles.get(type);
            if (javaClass == null) {
                this.unregistered(type);
                continue;
            }
            found = true;
            classes.addAll(javaClass);
        }
        if (!found) {
            classes.addAll(this.findBaseRoles());
            return classes;
        }
        return classes;
    }

    public boolean isNamedTypePresent() {
        return !this.empty;
    }

    public boolean isTypeRecorded(URI type) {
        return this.roles.containsKey(type);
    }

    public synchronized Set<Class<?>> recordRoles(Set<Class<?>> role, URI uri) {
        List<Class<?>> set = this.roles.get(uri);
        Set<Object> changed = new HashSet();
        if (set == null) {
            List<Class<?>> bar = this.roles.get(this.baseType);
            if (bar == null) {
                changed = role;
            } else {
                changed.addAll(bar);
                changed.addAll(role);
            }
        } else {
            changed.addAll(set);
            changed.addAll(role);
        }
        if (set == null || changed.size() != set.size()) {
            this.empty &= uri.equals((Object)this.baseType);
            this.roles.put(uri, Arrays.asList(changed.toArray(new Class[changed.size()])));
        }
        return changed;
    }

    public synchronized void recordBaseRole(Class<?> role) {
        for (Map.Entry<URI, List<Class<?>>> e : this.roles.entrySet()) {
            List<Class<?>> set = e.getValue();
            boolean contains = false;
            for (Class<?> c : set) {
                if (!role.equals(c)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            ArrayList ar = new ArrayList(set.size() + 1);
            ar.addAll(set);
            ar.add(role);
            e.setValue(ar);
        }
    }

    private Collection<Class<?>> findBaseRoles() {
        return this.roles.get(this.baseType);
    }

    private void unregistered(URI type) {
        if (!this.unregisteredTypes.containsKey(type)) {
            this.unregisteredTypes.put(type, Boolean.TRUE);
            this.logger.info("Unregistered type {}", (Object)type);
        }
    }
}

