/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openrdf.model.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeMapper
implements Cloneable {
    private final Logger logger = LoggerFactory.getLogger(TypeMapper.class);
    private Map<Class<?>, URI> types = new ConcurrentHashMap(256);

    public TypeMapper clone() {
        try {
            TypeMapper cloned = (TypeMapper)super.clone();
            cloned.types = new ConcurrentHashMap(this.types);
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public URI findType(Class<?> role) {
        return this.types.get(role);
    }

    public synchronized void recordRole(Class<?> role, URI rdfType) {
        assert (rdfType != null);
        if (!this.types.containsKey(role)) {
            this.types.put(role, rdfType);
            if (this.logger.isDebugEnabled()) {
                String sn = role.getSimpleName();
                String cn = role.getName().replace('.', '/') + ".class";
                ClassLoader cl = this.getClassLoader(role);
                URL location = cl.getResource(cn);
                this.logger.debug("Role {} loaded from {}", (Object)sn, (Object)location);
            }
        }
    }

    private ClassLoader getClassLoader(Class<?> role) {
        ClassLoader cl = role.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        if (cl == null) {
            cl = TypeMapper.class.getClassLoader();
        }
        return cl;
    }
}

