/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.object.managers.helpers;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WeakValueMap<K, V>
extends AbstractMap<K, V> {
    final Map<K, WeakEntry> hash;
    final ReferenceQueue<? super V> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet;
    private Collection<V> values;

    public WeakValueMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<K, WeakEntry>(initialCapacity, loadFactor);
    }

    public WeakValueMap(int initialCapacity) {
        this.hash = new HashMap<K, WeakEntry>(initialCapacity);
    }

    public WeakValueMap() {
        this.hash = new HashMap<K, WeakEntry>();
    }

    public WeakValueMap(Map<? extends K, ? extends V> m) {
        this.hash = new HashMap<K, WeakEntry>(m.size());
        this.putAll(m);
    }

    @Override
    public int size() {
        this.compact();
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        this.compact();
        return this.hash.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.compact();
        WeakEntry ref = this.hash.get(key);
        return ref != null && ref.get() != null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.compact();
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        return this.refGet(this.hash.get(key));
    }

    @Override
    public V put(K key, V value) {
        this.compact();
        return this.refGet(this.hash.put(key, new WeakEntry(key, value)));
    }

    @Override
    public V remove(Object key) {
        this.compact();
        return this.refGet(this.hash.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.compact();
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.hash.put(e.getKey(), new WeakEntry(e.getKey(), e.getValue()));
        }
    }

    @Override
    public void clear() {
        this.hash.clear();
    }

    @Override
    public Set<K> keySet() {
        this.compact();
        return this.hash.keySet();
    }

    @Override
    public synchronized Collection<V> values() {
        this.compact();
        if (this.values != null) {
            return this.values;
        }
        this.values = new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private Iterator<WeakEntry> i;
                    {
                        this.i = WeakValueMap.this.hash.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public V next() {
                        return WeakValueMap.this.refGet(this.i.next());
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return WeakValueMap.this.hash.size();
            }

            @Override
            public boolean isEmpty() {
                return WeakValueMap.this.hash.isEmpty();
            }

            @Override
            public void clear() {
                WeakValueMap.this.hash.clear();
            }
        };
        return this.values;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        this.compact();
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, WeakEntry>> i;
                    {
                        this.i = WeakValueMap.this.hash.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new Map.Entry<K, V>(){
                            private Map.Entry<K, WeakEntry> entry;
                            {
                                this.entry = i.next();
                            }

                            @Override
                            public K getKey() {
                                return this.entry.getKey();
                            }

                            @Override
                            public V getValue() {
                                return WeakValueMap.this.refGet(this.entry.getValue());
                            }

                            @Override
                            public V setValue(V value) {
                                return WeakValueMap.this.refGet(this.entry.setValue(new WeakEntry(this.entry.getKey(), value)));
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }

            @Override
            public int size() {
                return WeakValueMap.this.hash.size();
            }

            @Override
            public boolean isEmpty() {
                return WeakValueMap.this.hash.isEmpty();
            }

            @Override
            public void clear() {
                WeakValueMap.this.hash.clear();
            }
        };
        return this.entrySet;
    }

    private synchronized void compact() {
        WeakEntry ref;
        while ((ref = (WeakEntry)this.queue.poll()) != null) {
            if (ref != this.hash.get(ref.getKey())) continue;
            this.hash.remove(ref.getKey());
        }
    }

    V refGet(WeakEntry ref) {
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    private class WeakEntry
    extends WeakReference<V> {
        private K key;

        public WeakEntry(K key, V value) {
            super(value, WeakValueMap.this.queue);
            this.key = key;
            if (key == null || value == null) {
                throw new NullPointerException();
            }
        }

        public K getKey() {
            return this.key;
        }
    }
}

