/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object;

import info.aduna.net.ParsedURI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.openrdf.OpenRDFException;
import org.openrdf.http.object.Version;
import org.openrdf.http.object.cli.Command;
import org.openrdf.http.object.cli.CommandSet;
import org.openrdf.http.object.concurrent.ManagedExecutors;
import org.openrdf.http.object.concurrent.ManagedThreadPool;
import org.openrdf.http.object.concurrent.ManagedThreadPoolListener;
import org.openrdf.http.object.logging.LoggingProperties;
import org.openrdf.http.object.management.JVMUsage;
import org.openrdf.http.object.management.KeyStoreImpl;
import org.openrdf.http.object.management.ObjectServer;
import org.openrdf.http.object.management.RepositoryMXBean;
import org.openrdf.http.object.util.ServerPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    public static final String NAME = Version.getInstance().getVersion();
    private static final CommandSet commands = new CommandSet(NAME);
    private final Logger logger = LoggerFactory.getLogger(Server.class);
    private String name;
    private ObjectServer node;

    public static void main(String[] args) throws IOException, OpenRDFException {
        final Server node = new Server();
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        node.stop();
                        node.destroy();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
            }));
            node.init(args);
            node.start();
            node.await();
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            System.err.println("Arguments: " + Arrays.toString(args));
            System.err.println(e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        finally {
            node.destroy();
        }
    }

    public Server() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server(File pidFile) throws IOException {
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String pid = bean.getName().replaceAll("@.*", "");
        FileWriter writer = new FileWriter(pidFile);
        try {
            writer.append(pid);
        }
        finally {
            writer.close();
        }
    }

    public void init(String ... args) {
        try {
            String ssl;
            Command line = commands.parse(args);
            if (line.has("help")) {
                line.printHelp();
                System.exit(0);
                return;
            }
            if (line.has("version")) {
                line.printCommandName();
                System.exit(0);
                return;
            }
            if (line.isParseError()) {
                line.printParseError();
                System.exit(2);
                return;
            }
            if (line.has("quiet")) {
                try {
                    this.logStdout();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            File[] dataDir = new File[]{new File("")};
            if (line.has("dataDir")) {
                dataDir = new File[line.getAll("dataDir").length];
                int i = 0;
                for (String name : line.getAll("dataDir")) {
                    dataDir[i++] = new File(name);
                }
            }
            try {
                this.storePID(line.get("pid"), dataDir);
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            String serverName = line.get("serverName");
            String ports = line.has("port") ? Arrays.toString(line.getAll("port")) : null;
            String string = ssl = line.has("ssl") ? Arrays.toString(line.getAll("ssl")) : null;
            this.name = line.has("port") ? line.get("port") : (line.has("ssl") ? line.get("ssl") : "0");
            ManagedExecutors.getInstance().addListener(new ManagedThreadPoolListener(){

                @Override
                public void threadPoolStarted(String name, ManagedThreadPool pool) {
                    Server.this.registerMBean(pool, Server.this.mbean(ManagedThreadPool.class, name));
                }

                @Override
                public void threadPoolTerminated(String name) {
                    Server.this.unregisterMBean(name, ManagedThreadPool.class);
                }
            });
            if (this.node != null) {
                this.node.destroy();
            }
            ClassLoader cl = Server.class.getClassLoader();
            ClassLoader cp = this.getClasspath(line.get("classpath"), cl);
            this.node = new ObjectServer(cp, dataDir);
            this.node.setServerName(serverName);
            this.node.setPorts(ports);
            this.node.setSSLPorts(ssl);
            if (line.has("timeout")) {
                this.node.setTimeout(Integer.parseInt(line.get("timeout")));
            }
            if (line.has("no-delay")) {
                this.node.setTcpNoDelay(true);
            }
            this.node.setCaching(line.has("caching") || !line.has("no-caching"));
            this.registerMBean(this.node, this.mbean(ObjectServer.class, this.name));
            this.registerMBean(new JVMUsage(), this.mbean(JVMUsage.class));
            LoggingProperties loggingBean = new LoggingProperties();
            this.registerMBean(loggingBean, this.mbean(LoggingProperties.class));
            KeyStoreImpl keystore = new KeyStoreImpl();
            this.registerMBean(keystore, this.mbean(KeyStoreImpl.class));
            this.poke();
            this.node.init();
            if (!line.has("trust")) {
                File[] writable = new File[dataDir.length + 1];
                for (int i = 0; i < dataDir.length; ++i) {
                    writable[i] = new File(dataDir[i], "repositories");
                }
                writable[dataDir.length] = loggingBean.getLoggingPropertiesFile();
                ServerPolicy.apply(new String[0], writable);
            }
        }
        catch (Throwable e) {
            while (e.getCause() != null) {
                e = e.getCause();
            }
            System.err.println("Arguments: " + Arrays.toString(args));
            System.err.println(e.toString());
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void start() throws Exception {
        this.poke();
        this.node.start();
    }

    public void stop() throws Exception {
        if (this.node != null) {
            this.node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() throws IOException, OpenRDFException {
        try {
            if (this.node != null) {
                this.node.destroy();
            }
        }
        finally {
            this.unregisterMBean(JVMUsage.class);
            this.unregisterMBean(LoggingProperties.class);
            this.unregisterMBean(KeyStoreImpl.class);
            ManagedExecutors.getInstance().cleanup();
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                if (this.name != null) {
                    mbs.unregisterMBean(new ObjectName(this.mbean(ObjectServer.class, this.name)));
                }
                QueryExp instanceOf = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                ObjectName rn = new ObjectName(this.getRepositoryMBeanPrefix() + ",*");
                for (ObjectName on : mbs.queryNames(rn, instanceOf)) {
                    mbs.unregisterMBean(on);
                }
            }
            catch (InstanceNotFoundException instanceOf) {
            }
            catch (JMException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException, OpenRDFException {
        ObjectServer objectServer = this.node;
        synchronized (objectServer) {
            this.poke();
            while (!this.node.isShutDown()) {
                this.node.wait();
                this.poke();
            }
        }
    }

    public void poke() throws OpenRDFException {
        String repositories = this.getRepositoryMBeanPrefix();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (this.node.isShutDown()) {
            try {
                QueryExp instanceOf = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                for (ObjectName on : mbs.queryNames(new ObjectName(repositories + ",*"), instanceOf)) {
                    mbs.unregisterMBean(on);
                }
                if (this.name != null) {
                    mbs.unregisterMBean(new ObjectName(this.mbean(ObjectServer.class, this.name)));
                    this.name = null;
                }
            }
            catch (JMException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
        } else {
            this.node.poke();
            Map<String, String> active = this.indexByPath(Arrays.asList(this.node.getRepositoryLocations()));
            try {
                QueryExp instanceOf = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                for (ObjectName on : mbs.queryNames(new ObjectName(repositories + ",*"), instanceOf)) {
                    if (active.keySet().contains(on.getKeyProperty("name"))) continue;
                    mbs.unregisterMBean(on);
                }
            }
            catch (JMException e) {
                this.logger.error(e.toString(), (Throwable)e);
            }
            for (Map.Entry<String, String> e : active.entrySet()) {
                try {
                    String oname = repositories + ",name=" + e.getKey();
                    if (mbs.isRegistered(new ObjectName(oname))) continue;
                    this.registerMBean(this.node.getRepositoryMXBean(e.getValue()), oname);
                }
                catch (MalformedObjectNameException ex) {
                    this.logger.error(ex.toString(), (Throwable)ex);
                }
            }
        }
    }

    <T> void registerMBean(T bean, String oname) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(bean, new ObjectName(oname));
        }
        catch (InstanceAlreadyExistsException e) {
            this.logger.debug(e.toString(), (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
    }

    void unregisterMBean(Class<?> beanClass) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName oname = new ObjectName("*:type=" + beanClass.getSimpleName() + ",*");
            for (Class<?> mx : beanClass.getInterfaces()) {
                if (!mx.getName().endsWith("Bean")) continue;
                QueryExp instanceOf = Query.isInstanceOf(Query.value(beanClass.getName()));
                for (ObjectName on : mbs.queryNames(oname, instanceOf)) {
                    mbs.unregisterMBean(on);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString(), (Throwable)e);
        }
    }

    void unregisterMBean(String name, Class<?> beanClass) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(new ObjectName(this.mbean(beanClass, name)))) {
                mbs.unregisterMBean(new ObjectName(this.mbean(beanClass, name)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String mbean(Class<?> beanClass) {
        String pkg = Server.class.getPackage().getName();
        String simple = beanClass.getSimpleName();
        StringBuilder sb = new StringBuilder();
        sb.append(pkg).append(":type=").append(simple);
        return sb.toString();
    }

    String mbean(Class<?> beanClass, String name) {
        String pkg = Server.class.getPackage().getName();
        String simple = beanClass.getSimpleName();
        StringBuilder sb = new StringBuilder();
        sb.append(pkg).append(":type=").append(simple);
        sb.append(",name=").append(name);
        return sb.toString();
    }

    private ClassLoader getClasspath(String cp, ClassLoader parent) throws MalformedURLException {
        if (cp == null || cp.length() == 0) {
            return parent;
        }
        String[] paths = cp.split(File.pathSeparator);
        URL[] urls = new URL[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            urls[i] = new File(paths[i]).toURI().toURL();
        }
        return new URLClassLoader(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storePID(String pidFile, File[] dataDir) throws IOException {
        File[] files;
        if (pidFile != null) {
            files = new File[]{new File(pidFile)};
            files[0].getParentFile().mkdirs();
            files[0].deleteOnExit();
        } else {
            files = new File[dataDir.length];
            for (int i = 0; i < dataDir.length; ++i) {
                File run = new File(dataDir[i], "run");
                files[i] = new File(run, "object-server.pid");
                files[i].getParentFile().mkdirs();
                files[i].deleteOnExit();
            }
        }
        RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
        String pid = bean.getName().replaceAll("@.*", "");
        for (File file : files) {
            FileWriter writer = new FileWriter(file);
            try {
                writer.append(pid);
            }
            finally {
                writer.close();
            }
        }
    }

    private Map<String, String> indexByPath(List<String> list) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(list.size());
        for (String item : list) {
            result.put(new ParsedURI(item).getPath().replace(':', '|'), item);
        }
        return result;
    }

    private String getRepositoryMBeanPrefix() {
        String pkg = Server.class.getPackage().getName();
        String simple = ObjectServer.class.getSimpleName();
        StringBuilder sb = new StringBuilder();
        sb.append(pkg).append(":type=").append(simple).append(".").append("Repository");
        sb.append(",").append(simple).append("=").append(this.name);
        return sb.toString();
    }

    private void logStdout() {
        System.setOut(new PrintStream(new OutputStream(){
            private int ret = "\r".getBytes()[0];
            private int newline = "\n".getBytes()[0];
            private Logger logger = LoggerFactory.getLogger((String)"stdout");
            private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public synchronized void write(int b) throws IOException {
                if (b == this.ret || b == this.newline) {
                    if (this.buffer.size() > 0) {
                        this.logger.info(this.buffer.toString());
                        this.buffer.reset();
                    }
                } else {
                    this.buffer.write(b);
                }
            }
        }, true));
        System.setErr(new PrintStream(new OutputStream(){
            private int ret = "\r".getBytes()[0];
            private int newline = "\n".getBytes()[0];
            private Logger logger = LoggerFactory.getLogger((String)"stderr");
            private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

            @Override
            public synchronized void write(int b) throws IOException {
                if (b == this.ret || b == this.newline) {
                    if (this.buffer.size() > 0) {
                        this.logger.warn(this.buffer.toString());
                        this.buffer.reset();
                    }
                } else {
                    this.buffer.write(b);
                }
            }
        }, true));
    }

    static {
        commands.require("d", "dataDir").arg("directory").desc("Sesame data dir to 'connect' to");
        commands.option("n", "serverName").arg("name").desc("Web server name");
        commands.option("p", "port").arg("number").desc("HTTP port number");
        commands.option("s", "ssl").arg("number").desc("HTTPS port number");
        commands.option("t", "timeout").arg("number").desc("socket timeout in milliseconds for TCP operations");
        commands.option("D", "no-delay").desc("Disables TCP_NODELAY (Nagle's algorithm)");
        commands.option("c", "caching").desc("Enable HTTP server side caching");
        commands.option("C", "no-caching").desc("Disable server side caching (no effect on client side caching)");
        commands.option("trust").desc("Allow all server code to read, write, and execute all files and directories according to the file system's ACL");
        commands.option("pid").arg("file").desc("File to store current process id");
        commands.option("q", "quiet").desc("Don't print status messages to standard output.");
        commands.option("cp", "classpath").arg("classpath").desc("Specifies a list of additional directories, JAR files, and ZIP archives to search for class files");
        commands.option("h", "help").desc("Print help (this message) and exit");
        commands.option("v", "version").desc("Print version information and exit");
    }
}

