/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object;

import info.aduna.io.IOUtil;
import info.aduna.net.ParsedURI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.UnmarshalException;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.datatype.DatatypeFactory;
import org.apache.commons.io.FileUtils;
import org.openrdf.http.object.Server;
import org.openrdf.http.object.Version;
import org.openrdf.http.object.cli.Command;
import org.openrdf.http.object.cli.CommandSet;
import org.openrdf.http.object.concurrent.ThreadPoolMXBean;
import org.openrdf.http.object.io.ChannelUtil;
import org.openrdf.http.object.management.JVMUsageMBean;
import org.openrdf.http.object.management.ObjectServerMBean;
import org.openrdf.http.object.management.RepositoryMXBean;
import org.openrdf.repository.manager.RepositoryProvider;

public class ServerControl {
    private static final String REPOSITORIES = "repositories";
    private static final String ATTACH_MACHINE = "com.sun.tools.attach.VirtualMachine";
    private static final String REPO_NAME = Server.class.getPackage().getName() + ":*,name=";
    public static final String NAME = Version.getInstance().getVersion();
    private static final String CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
    private static final String ENDPOINT_CONFIG = "@prefix rep: <http://www.openrdf.org/config/repository#>.\n@prefix hr: <http://www.openrdf.org/config/repository/http#>.\n<#{id}> a rep:Repository ;\n   rep:repositoryImpl [ rep:repositoryType 'openrdf:HTTPRepository' ; hr:repositoryURL <{url}> ];\n   rep:repositoryID '{id}'.\n";
    private static final ThreadFactory tfactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "ServerControl-Queue" + Integer.toHexString(r.hashCode()));
            t.setDaemon(true);
            return t;
        }
    };
    private static final CommandSet commands = new CommandSet(NAME);
    private Object vm;
    private MBeanServerConnection mbsc;
    private JVMUsageMBean usage;
    private ObjectServerMBean server;
    private Command line;
    private Server internalServer;

    public static void main(String[] args) {
        try {
            final ServerControl control = new ServerControl();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        control.destroy();
                    }
                    catch (Throwable e) {
                        ServerControl.println(e);
                    }
                }
            }));
            control.init(args);
            control.start();
            control.stop();
            control.destroy();
            System.exit(0);
        }
        catch (ClassNotFoundException e) {
            System.err.print("Missing jar with: ");
            System.err.println(e.toString());
            System.exit(5);
        }
        catch (Throwable e) {
            ServerControl.println(e);
            System.err.println("Arguments: " + Arrays.toString(args));
            System.exit(1);
        }
    }

    static void println(Throwable e) {
        Throwable cause = e.getCause();
        if (cause == null && e.getMessage() == null) {
            e.printStackTrace(System.err);
        } else if (cause != null) {
            ServerControl.println(cause);
        } else {
            e.printStackTrace(System.err);
        }
    }

    public ServerControl() {
        this.mbsc = ManagementFactory.getPlatformMBeanServer();
    }

    public ServerControl(File pidFile) throws Exception {
        this.setPid(IOUtil.readString((File)pidFile).trim());
    }

    public void init(String ... args) {
        try {
            this.line = commands.parse(args);
            if (this.line.has("help")) {
                this.line.printHelp();
                System.exit(0);
                return;
            }
            if (this.line.has("version")) {
                this.line.printCommandName();
                System.exit(0);
                return;
            }
            if (this.line.isParseError()) {
                this.line.printParseError();
                System.exit(2);
                return;
            }
            if (!this.line.has("identifier") && (this.line.has("endpoint") || this.line.has("conf") || this.line.has("update") || this.line.has("query") || this.line.has("read") || this.line.has("write"))) {
                System.err.println("Missing required option: identifier");
                this.line.printHelp();
                System.exit(2);
                return;
            }
            if (this.line.has("identifier") && this.line.has("endpoint") && this.line.getAll("identifier").length < this.line.getAll("endpoint").length) {
                System.err.println("Not enough identifier arguments");
                this.line.printHelp();
                System.exit(2);
                return;
            }
            if (this.line.has("identifier") && this.line.has("conf") && this.line.getAll("identifier").length < this.line.getAll("conf").length) {
                System.err.println("Not enough identifier arguments");
                this.line.printHelp();
                System.exit(2);
                return;
            }
            if (!this.line.has("file") && (this.line.has("read") || this.line.has("write"))) {
                System.err.println("Missing required option: file");
                this.line.printHelp();
                System.exit(2);
                return;
            }
            if (this.line.has("pid")) {
                this.setPid(IOUtil.readString((File)new File(this.line.get("pid"))).trim());
            } else if (this.line.has("dataDir")) {
                File run = new File(this.line.get("dataDir"), "run");
                File pidFile = new File(run, "object-server.pid");
                if (pidFile.canRead()) {
                    this.setPid(IOUtil.readString((File)pidFile).trim());
                } else if (this.getObjectNames(ObjectServerMBean.class, this.mbsc).isEmpty()) {
                    this.initInternalServer(this.line.getAll("dataDir"));
                }
            }
            for (ObjectName name : this.getObjectNames(ObjectServerMBean.class, this.mbsc)) {
                this.server = JMX.newMXBeanProxy(this.mbsc, name, ObjectServerMBean.class);
            }
            for (ObjectName name : this.getObjectNames(JVMUsageMBean.class, this.mbsc)) {
                this.usage = JMX.newMXBeanProxy(this.mbsc, name, JVMUsageMBean.class);
            }
            if (this.server == null) {
                System.err.println("Object server was not found, provide a different pid or dataDir option");
                System.exit(2);
            }
        }
        catch (Throwable e) {
            ServerControl.println(e);
            System.err.println("Arguments: " + Arrays.toString(args));
            System.exit(1);
        }
    }

    public void start() throws Exception {
        RepositoryMXBean repo;
        Set<ObjectName> names;
        QueryExp instanceOf;
        String path;
        String base;
        int i;
        String[] ids;
        int n;
        String[] name;
        if (this.line.has("serverName")) {
            name = this.line.get("serverName");
            if (name == null || name.length() == 0) {
                System.out.println(this.server.getServerName());
            } else {
                this.server.setServerName((String)name);
            }
        }
        if (this.line.has("port")) {
            if (this.line.getAll("port").length > 0) {
                this.server.setPorts(Arrays.toString(this.line.getAll("port")));
            } else {
                System.out.println(this.server.getPorts());
            }
        }
        if (this.line.has("ssl")) {
            if (this.line.getAll("ssl").length > 0) {
                this.server.setSSLPorts(Arrays.toString(this.line.getAll("ssl")));
            } else {
                System.out.println(this.server.getSSLPorts());
            }
        }
        if (this.line.has("status")) {
            System.out.println(this.server.getStatus());
        }
        if (this.line.has("dump")) {
            this.dumpService(this.line.get("dump") + File.separatorChar);
        }
        if (this.line.has("remove")) {
            name = this.line.getAll("remove");
            int n2 = name.length;
            for (n = 0; n < n2; ++n) {
                String id3 = name[n];
                this.server.removeRepository(id3);
            }
        }
        if (this.line.has("endpoint")) {
            ids = this.getLocations();
            String[] urls = this.line.getAll("endpoint");
            for (i = 0; i < urls.length; ++i) {
                String id = RepositoryProvider.getRepositoryIdOfRepository((String)ids[i]);
                System.out.println("Assigning endpoint " + urls[i] + " to ID " + id);
                String string = ENDPOINT_CONFIG.replace("{id}", id).replace("{url}", urls[i]);
                base = new File("").toURI().toASCIIString();
                this.server.addRepository(ids[i], base, string);
            }
        }
        if (this.line.has("conf")) {
            ids = this.getLocations();
            String[] files = this.line.getAll("conf");
            for (i = 0; i < files.length; ++i) {
                File file = new File(files[i]);
                String string = FileUtils.readFileToString((File)file);
                base = file.toURI().toASCIIString();
                String id2 = this.server.addRepository(ids[i], base, string);
                System.out.println("Assigning endpoint " + files[i] + " to ID " + id2);
            }
        }
        if (this.line.has("list")) {
            for (String id : this.server.getRepositoryLocations()) {
                System.out.println(id);
            }
        }
        if (this.line.has("identifier") && this.line.has("prefix")) {
            ids = this.getLocations();
            String[] prefixes = this.line.getAll("prefix");
            for (i = 0; i < prefixes.length; ++i) {
                if (i >= ids.length) {
                    this.server.addRepositoryPrefix(ids[ids.length - 1], prefixes[i]);
                    continue;
                }
                this.server.setRepositoryPrefixes(ids[i], new String[]{prefixes[i]});
            }
        }
        if (this.line.has("update")) {
            ids = this.line.getAll("update");
            int n3 = ids.length;
            for (n = 0; n < n3; ++n) {
                String update = ids[n];
                for (String loc : this.getLocations()) {
                    path = new ParsedURI(loc).getPath();
                    instanceOf = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                    names = this.mbsc.queryNames(new ObjectName(REPO_NAME + path), instanceOf);
                    for (ObjectName objectName : names) {
                        repo = JMX.newMXBeanProxy(this.mbsc, objectName, RepositoryMXBean.class);
                        repo.sparqlUpdate(update);
                    }
                }
            }
        }
        if (this.line.has("query")) {
            ids = this.line.getAll("query");
            int n4 = ids.length;
            for (n = 0; n < n4; ++n) {
                String query = ids[n];
                for (String loc : this.getLocations()) {
                    path = new ParsedURI(loc).getPath();
                    instanceOf = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                    names = this.mbsc.queryNames(new ObjectName(REPO_NAME + path), instanceOf);
                    for (ObjectName objectName : names) {
                        repo = JMX.newMXBeanProxy(this.mbsc, objectName, RepositoryMXBean.class);
                        for (String line : repo.sparqlQuery(query)) {
                            System.out.println(line);
                        }
                    }
                }
            }
        }
        if (this.line.has("write")) {
            byte[] content = FileUtils.readFileToByteArray((File)new File(this.line.get("file")));
            String[] stringArray = this.line.getAll("write");
            n = stringArray.length;
            for (int query = 0; query < n; ++query) {
                String string = stringArray[query];
                for (String loc : this.getLocations()) {
                    String path2 = new ParsedURI(loc).getPath();
                    QueryExp instanceOf2 = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                    Set<ObjectName> names2 = this.mbsc.queryNames(new ObjectName(REPO_NAME + path2), instanceOf2);
                    for (ObjectName name3 : names2) {
                        RepositoryMXBean repo2 = JMX.newMXBeanProxy(this.mbsc, name3, RepositoryMXBean.class);
                        repo2.storeBinaryBlob(string, content);
                    }
                }
            }
        }
        if (this.line.has("read")) {
            for (String uri : this.line.getAll("read")) {
                for (String loc : this.getLocations()) {
                    path = new ParsedURI(loc).getPath();
                    instanceOf = Query.isInstanceOf(Query.value(RepositoryMXBean.class.getName()));
                    names = this.mbsc.queryNames(new ObjectName(REPO_NAME + path), instanceOf);
                    for (ObjectName objectName : names) {
                        repo = JMX.newMXBeanProxy(this.mbsc, objectName, RepositoryMXBean.class);
                        byte[] content = repo.readBinaryBlob(uri);
                        FileUtils.writeByteArrayToFile((File)new File(this.line.get("file")), (byte[])content);
                    }
                }
            }
        }
        if (this.line.has("reset")) {
            this.server.resetCache();
        }
        if (this.line.has("restart")) {
            this.server.restart();
        }
        if (this.line.has("stop")) {
            this.destroyService();
        }
    }

    public void stop() throws Throwable {
    }

    public void destroy() throws Exception {
        if (this.internalServer != null) {
            this.internalServer.destroy();
            this.internalServer = null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean destroyService() throws Exception {
        block14: {
            if (!this.server.isShutDown()) break block14;
            return false;
            {
                catch (UndeclaredThrowableException e) {
                    try {
                        throw e.getCause();
                    }
                    catch (Exception cause) {
                        throw cause;
                    }
                    catch (Throwable cause) {
                        throw e;
                    }
                }
            }
        }
        try {
            try {
                this.server.stop();
            }
            finally {
                this.server.destroy();
            }
            this.info("Server has stopped");
            return true;
        }
        catch (UndeclaredThrowableException e) {
            if (e.getCause() instanceof InstanceNotFoundException) {
                this.info("Server has been destroyed");
                return true;
            }
            throw e;
            catch (UnmarshalException e2) {
                if (e2.getCause() instanceof IOException) {
                    this.info("Server has shutdown");
                    return true;
                }
                throw e2;
            }
        }
    }

    private void dumpService(String dir) throws Exception {
        GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        DatatypeFactory df = DatatypeFactory.newInstance();
        String stamp = df.newXMLGregorianCalendar(now).toXMLFormat();
        stamp = stamp.replaceAll("[^0-9]", "");
        if (this.vm != null) {
            this.executeVMCommand(this.vm, "remoteDataDump", dir + "threads-" + stamp + ".tdump", new String[0]);
            this.heapDump(this.vm, dir + "heap-" + stamp + ".hprof");
            this.executeVMCommand(this.vm, "heapHisto", dir + "heap-" + stamp + ".histo", new String[0]);
            this.connectionDump(this.mbsc, dir + "server-" + stamp + ".csv");
            this.poolDump(this.mbsc, dir + "pool-" + stamp + ".tdump");
        }
        this.usageDump(this.mbsc, dir + "usage-" + stamp + ".txt");
        this.netStatistics(dir + "netstat-" + stamp + ".txt");
        this.topStatistics(dir + "top-" + stamp + ".txt");
    }

    private void setPid(String pid) throws Exception {
        this.info("Connecting to " + pid);
        this.vm = this.getRemoteVirtualMachine(pid);
        this.mbsc = this.getMBeanConnection(this.vm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heapDump(Object vm, String hprof) throws Exception {
        String[] args = new String[]{hprof};
        Method remoteDataDump = vm.getClass().getMethod("dumpHeap", Object[].class);
        InputStream in = (InputStream)remoteDataDump.invoke(vm, new Object[]{args});
        try {
            ChannelUtil.transfer(in, (OutputStream)System.out);
        }
        finally {
            in.close();
        }
        this.info(hprof);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeVMCommand(Object vm, String cmd, String filename, String ... args) throws Exception {
        Method remoteDataDump = vm.getClass().getMethod(cmd, Object[].class);
        InputStream in = (InputStream)remoteDataDump.invoke(vm, new Object[]{args});
        try {
            FileOutputStream out = new FileOutputStream(filename);
            try {
                ChannelUtil.transfer(in, (OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        this.info(filename);
    }

    private void connectionDump(MBeanServerConnection mbsc, String filename) throws MalformedObjectNameException, IOException {
        for (ObjectName name : this.getObjectNames(ObjectServerMBean.class, mbsc)) {
            ObjectServerMBean server = JMX.newMXBeanProxy(mbsc, name, ObjectServerMBean.class);
            server.connectionDumpToFile(filename);
            this.info(filename);
        }
    }

    private Set<ObjectName> getObjectNames(Class<?> mx, MBeanServerConnection mbsc) throws IOException, MalformedObjectNameException {
        String pkg = Server.class.getPackage().getName();
        ObjectName name = new ObjectName(pkg + ":*");
        QueryExp instanceOf = Query.isInstanceOf(Query.value(mx.getName()));
        return mbsc.queryNames(name, instanceOf);
    }

    private void poolDump(MBeanServerConnection mbsc, String filename) throws MalformedObjectNameException, IOException {
        boolean empty = true;
        for (ObjectName mon : this.getObjectNames(ThreadPoolMXBean.class, mbsc)) {
            ThreadPoolMXBean pool = JMX.newMXBeanProxy(mbsc, mon, ThreadPoolMXBean.class);
            pool.threadDumpToFile(filename);
            empty = false;
        }
        if (!empty) {
            this.info(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usageDump(MBeanServerConnection mbsc, String filename) throws Exception {
        block9: {
            try {
                if (this.usage == null) break block9;
                String[] summary = this.usage.getJVMUsage();
                PrintWriter w = new PrintWriter(filename);
                try {
                    for (String line : summary) {
                        w.println(line);
                    }
                }
                finally {
                    w.close();
                }
                this.info(filename);
            }
            catch (UndeclaredThrowableException e) {
                try {
                    throw e.getCause();
                }
                catch (Exception cause) {
                    throw cause;
                }
                catch (Throwable cause) {
                    throw e;
                }
            }
        }
    }

    private Object getRemoteVirtualMachine(String pid) throws Exception {
        Class<?> VM = this.loadVirtualMatchineClass();
        Method attach = VM.getDeclaredMethod("attach", String.class);
        this.info("Connecting to " + pid);
        try {
            return attach.invoke(null, pid);
        }
        catch (InvocationTargetException e) {
            try {
                throw e.getCause();
            }
            catch (Exception cause) {
                throw cause;
            }
            catch (Throwable cause) {
                throw e;
            }
        }
    }

    private Class<?> loadVirtualMatchineClass() throws ClassNotFoundException, MalformedURLException {
        try {
            return Class.forName(ATTACH_MACHINE);
        }
        catch (ClassNotFoundException e) {
            try {
                File jre = new File(System.getProperty("java.home"));
                File jdk = jre.getParentFile();
                File tools = new File(new File(jdk, "lib"), "tools.jar");
                URL url = tools.toURI().toURL();
                URLClassLoader cl = new URLClassLoader(new URL[]{url});
                return Class.forName(ATTACH_MACHINE, true, cl);
            }
            catch (ClassNotFoundException exc) {
                System.err.println("MISSING tools.jar in classpath");
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void netStatistics(String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        try {
            if (this.exec(out, new ByteArrayOutputStream(), "netstat", "-tnpo")) {
                this.exec(out, System.err, "netstat", "-st");
                this.info(fileName);
            } else {
                new File(fileName).delete();
            }
        }
        catch (IOException e) {
            new File(fileName).delete();
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topStatistics(String fileName) throws IOException {
        FileOutputStream out = new FileOutputStream(fileName);
        try {
            if (this.exec(out, System.err, "top", "-bn", "1")) {
                this.info(fileName);
            } else {
                new File(fileName).delete();
            }
        }
        catch (IOException e) {
            new File(fileName).delete();
        }
        finally {
            out.close();
        }
    }

    private boolean exec(OutputStream stdout, OutputStream stderr, String ... command) throws IOException {
        ProcessBuilder process = new ProcessBuilder(command);
        Process p = process.start();
        Thread tin = this.transfer(p.getInputStream(), stdout);
        Thread terr = this.transfer(p.getErrorStream(), stderr);
        p.getOutputStream().close();
        try {
            int ret = p.waitFor();
            if (tin != null) {
                tin.join();
            }
            if (terr != null) {
                terr.join();
            }
            return ret == 0;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private Thread transfer(final InputStream in, final OutputStream out) {
        if (in == null) {
            return null;
        }
        Thread thread = tfactory.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        int read;
                        byte[] buf = new byte[1024];
                        while ((read = in.read(buf)) >= 0) {
                            out.write(buf, 0, read);
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        thread.start();
        return thread;
    }

    private void info(String message) {
        System.err.println(message);
    }

    private MBeanServerConnection getMBeanConnection(Object vm) throws Exception {
        Method getAgentProperties = vm.getClass().getMethod("getAgentProperties", new Class[0]);
        Method getSystemProperties = vm.getClass().getMethod("getSystemProperties", new Class[0]);
        Method loadAgent = vm.getClass().getMethod("loadAgent", String.class);
        Properties properties = (Properties)getAgentProperties.invoke(vm, new Object[0]);
        String connectorAddress = properties.getProperty(CONNECTOR_ADDRESS);
        if (connectorAddress == null) {
            properties = (Properties)getSystemProperties.invoke(vm, new Object[0]);
            String agent = properties.getProperty("java.home") + File.separator + "lib" + File.separator + "management-agent.jar";
            loadAgent.invoke(vm, agent);
            properties = (Properties)getAgentProperties.invoke(vm, new Object[0]);
            connectorAddress = properties.getProperty(CONNECTOR_ADDRESS);
        }
        JMXServiceURL service = new JMXServiceURL(connectorAddress);
        JMXConnector connector = JMXConnectorFactory.connect(service);
        return connector.getMBeanServerConnection();
    }

    private String[] getLocations() {
        String[] ids = this.line.getAll("identifier");
        if (ids == null || !this.line.has("dataDir")) {
            return ids;
        }
        String[] dataDir = this.line.getAll("dataDir");
        String[] locations = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            File repositories = new File(dataDir[Math.max(i, dataDir.length - 1)], REPOSITORIES);
            locations[i] = URI.create(ids[i]).isAbsolute() ? ids[i] : new File(repositories, ids[i]).toURI().toASCIIString();
        }
        return locations;
    }

    private void initInternalServer(String[] dataDir) {
        String[] args = new String[dataDir.length + 2];
        args[0] = "--trust";
        args[1] = "--dataDir";
        System.arraycopy(dataDir, 0, args, 2, dataDir.length);
        this.internalServer = new Server();
        this.internalServer.init(args);
    }

    static {
        commands.option("d", "dataDir").arg("directory").desc("Sesame data dir to 'connect' to");
        commands.option("pid").arg("file").desc("File to read the server process id to monitor");
        commands.option("n", "serverName").optional("name").desc("Web server name");
        commands.option("p", "port").optional("number").desc("HTTP port number");
        commands.option("s", "ssl").optional("number").desc("HTTPS port number");
        commands.option("status").desc("Print status of server and exit");
        commands.option("dump").arg("directory").desc("Use the directory to dump the server status in the given directory");
        commands.option("remove").arg("Local endpoint file: location").desc("Remove SPARQL endpoint repository from server");
        commands.option("endpoint").arg("Remote SPARQL endpoint URL").desc("Adds or updates SPARQL endpoint URL");
        commands.option("c", "conf").arg("file").desc("The local repository config file to update with");
        commands.option("l", "list").desc("List local endpoint locations");
        commands.option("i", "identifier").arg("Local endpoint location").desc("Endpoint to modify");
        commands.option("x", "prefix").arg("URL prefix").desc("URL prefix to map to the given endpoint");
        commands.option("u", "update").arg("SPARQL Update").desc("Execute update against endpoint");
        commands.option("q", "query").arg("SPARQL Query").desc("Evaluate query against endpoint");
        commands.option("w", "write").arg("BLOB URI").desc("Store a file into this URI for the endpoint");
        commands.option("r", "read").arg("BLOB URI").desc("Read this URI for from the endpoint into a file");
        commands.option("f", "file").arg("BLOB file").desc("Local file to read or write BLOB content to or from");
        commands.option("reset").desc("Empty any cache on the server");
        commands.option("restart").desc("Restart the server");
        commands.option("stop").desc("Use the PID file to shutdown the server");
        commands.option("h", "help").desc("Print help (this message) and exit");
        commands.option("v", "version").desc("Print version information and exit");
    }
}

