/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public class Version {
    private static final String VERSION_PATH = "META-INF/maven/org.openrdf.alibaba/alibaba-http-object/pom.properties";
    private static Version instance = new Version(Version.loadVersion(Version.class.getClassLoader(), "META-INF/maven/org.openrdf.alibaba/alibaba-http-object/pom.properties"));
    private final String product = "AliBaba ObjectServer";
    private final int major;
    private final int release;
    private final int maintenance;
    private final String qualifier;
    private final int development;
    private final String build;

    public static void main(String[] args) {
        System.out.println(Version.getInstance().getVersion());
    }

    public static Version getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadVersion(ClassLoader cl, String properties) {
        String implVer = Version.class.getPackage().getImplementationVersion();
        if (implVer != null) {
            return implVer;
        }
        try {
            InputStream in = cl.getResourceAsStream(properties);
            if (in == null) return "devel";
            try {
                Properties result = new Properties();
                result.load(in);
                String version = result.getProperty("version");
                if (version == null) return "devel";
                String string = version.trim();
                return string;
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Version.class).warn("Unable to read version info", (Throwable)e);
        }
        return "devel";
    }

    Version(String version) {
        this.major = this.parseInt(version, "([0-9]+)\\b.*");
        this.release = this.parseInt(version, "[0-9]+\\.([0-9]+)\\b.*");
        this.maintenance = this.parseInt(version, "[0-9]+\\.[0-9]+\\.([0-9]+)\\b.*");
        this.qualifier = this.parseString(version, "[0-9\\.]+-([A-Za-z\\-]+?)(\\-?[0-9]+)?(\\+[0-9A-Za-z\\-\\.]+)?");
        this.development = this.parseInt(version, "[0-9\\.]+-[A-Za-z\\-]*([0-9]+)(\\+[0-9A-Za-z\\-\\.]+)?");
        this.build = this.parseString(version, "[0-9A-Za-z\\.\\-]*\\+([0-9A-Za-z\\-\\.]+)");
    }

    private int parseInt(String version, String pattern) {
        String str = this.parseString(version, pattern);
        if (str == null) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    private String parseString(String version, String pattern) {
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(version);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public String getVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProduct());
        sb.append("/").append(this.getVersionCode());
        if (this.getBuildIdentifier() != null) {
            sb.append("+").append(this.getBuildIdentifier());
        }
        return sb.toString();
    }

    public String getVersionCode() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMajorVersionNum());
        sb.append(".").append(this.getReleaseVersionNum());
        if (this.maintenance >= 0) {
            sb.append(".").append(this.getMaintenanceVersionNum());
        }
        if (this.qualifier != null) {
            sb.append("-").append(this.getQualifierIdentifier());
            if (this.development >= 0) {
                sb.append(this.getDevelopmentVersionNum());
            }
        } else if (this.development >= 0) {
            sb.append("-").append(this.getDevelopmentVersionNum());
        }
        return sb.toString();
    }

    public String getProduct() {
        return "AliBaba ObjectServer";
    }

    public int getMajorVersionNum() {
        return Math.max(0, this.major);
    }

    public int getReleaseVersionNum() {
        return Math.max(0, this.release);
    }

    public int getMaintenanceVersionNum() {
        return Math.max(0, this.maintenance);
    }

    public String getQualifierIdentifier() {
        return this.qualifier;
    }

    public int getDevelopmentVersionNum() {
        return Math.max(0, this.development);
    }

    public String getBuildIdentifier() {
        return this.build;
    }
}

