/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.StreamingHttpEntity;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.openrdf.http.object.io.ChannelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLog
implements AsyncExecChain {
    private static final String NIL = "-";
    private static final String FORENSIC_ATTR = AccessLog.class.getName() + "#forensicId";
    private static final Pattern TOKENS_REGEX = Pattern.compile("\\s*([\\w\\!\\#\\$\\%\\&\\'\\*\\+\\-\\.\\^\\_\\`\\~]+)(?:\\s*=\\s*(?:\"([^\"]*)\"|([^,\"]*)))?\\s*,?");
    private final Logger logger = LoggerFactory.getLogger(AccessLog.class);
    private final String uid = "t" + Long.toHexString(System.currentTimeMillis()) + "x";
    private final AtomicLong seq = new AtomicLong(0L);
    private final AsyncExecChain delegate;

    public AccessLog(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        final String addr = this.getClientAddress(context);
        this.traceRequest(request, context, addr == null);
        return this.delegate.execute(target, request, context, new ResponseCallback(callback){

            @Override
            public void completed(HttpResponse result) {
                try {
                    AccessLog.this.logResponse(request, context, result);
                    super.completed(result);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
            }

            @Override
            public void failed(Exception ex) {
                AccessLog.this.logCancel(addr, request);
                super.failed(ex);
            }

            @Override
            public void cancelled() {
                AccessLog.this.logCancel(addr, request);
                super.cancelled();
            }
        });
    }

    void logResponse(HttpRequest req, HttpContext context, HttpResponse resp) {
        final String addr = this.getClientAddress(context);
        this.traceResponse(req, context, resp, addr == null);
        if (addr == null) {
            return;
        }
        final int code = resp.getStatusLine().getStatusCode();
        if (this.logger.isInfoEnabled() || this.logger.isWarnEnabled() && code >= 400 || this.logger.isErrorEnabled() && code >= 500) {
            final String username = this.getUsername(req).replaceAll("\\s+", "_");
            final String line = req.getRequestLine().toString();
            final Header referer = req.getFirstHeader("Referer");
            final Header agent = req.getFirstHeader("User-Agent");
            HttpEntity entity = resp.getEntity();
            if (entity == null) {
                this.log(addr, username, line, code, 0L, referer, agent);
            } else {
                final long length = entity.getContentLength();
                resp.setEntity((HttpEntity)new StreamingHttpEntity(entity){

                    @Override
                    protected InputStream getDelegateContent() throws IOException {
                        InputStream in = super.getDelegateContent();
                        return AccessLog.this.logOnClose(addr, username, line, code, length, referer, agent, in);
                    }
                });
            }
        }
    }

    InputStream logOnClose(final String addr, final String username, final String line, final int code, final long length, final Header referer, final Header agent, InputStream in) {
        final ReadableByteChannel delegate = ChannelUtil.newChannel(in);
        return ChannelUtil.newInputStream(new ReadableByteChannel(){
            private long size = 0L;
            private boolean complete;
            private boolean error;

            @Override
            public boolean isOpen() {
                return delegate.isOpen();
            }

            @Override
            public synchronized void close() throws IOException {
                delegate.close();
                if (!this.complete) {
                    this.complete = true;
                    if (this.error) {
                        AccessLog.this.log(addr, username, line, 599, this.size, referer, agent);
                    } else if (this.size < length) {
                        AccessLog.this.log(addr, username, line, 499, this.size, referer, agent);
                    } else {
                        AccessLog.this.log(addr, username, line, code, this.size, referer, agent);
                    }
                }
            }

            @Override
            public synchronized int read(ByteBuffer dst) throws IOException {
                this.error = true;
                int read = delegate.read(dst);
                if (read < 0) {
                    this.complete = true;
                    AccessLog.this.log(addr, username, line, code, this.size, referer, agent);
                } else {
                    this.size += (long)read;
                }
                this.error = false;
                return read;
            }
        });
    }

    void logCancel(String addr, HttpRequest request) {
        String username = this.getUsername(request).replaceAll("\\s+", "_");
        String line = request.getRequestLine().toString();
        Header referer = request.getFirstHeader("Referer");
        Header agent = request.getFirstHeader("User-Agent");
        this.log(addr, username, line, 599, 0L, referer, agent);
    }

    void log(String addr, String username, String line, int code, long length, Header referer, Header agent) {
        StringBuilder sb = new StringBuilder();
        sb.append(addr).append('\t').append(username);
        sb.append('\t').append('\"').append(line).append('\"');
        sb.append('\t').append(code).append('\t').append(length);
        if (referer == null) {
            sb.append('\t').append('-');
        } else {
            sb.append('\t').append('\"').append(referer.getValue()).append('\"');
        }
        if (agent == null) {
            sb.append('\t').append('-');
        } else {
            sb.append('\t').append('\"').append(agent.getValue()).append('\"');
        }
        if (code < 400 || code == 401) {
            this.logger.info(sb.toString());
        } else if (code < 500) {
            this.logger.warn(sb.toString());
        } else {
            this.logger.error(sb.toString());
        }
    }

    private String getUsername(HttpRequest req) {
        for (Header hd : req.getHeaders("Authorization")) {
            Matcher m = TOKENS_REGEX.matcher(hd.getValue());
            while (m.find()) {
                String key = m.group(1);
                if (!"username".equals(key)) continue;
                return m.group(2);
            }
        }
        for (Header hd : req.getHeaders("Cookie")) {
            for (String cookie : hd.getValue().split("\\s*,\\s*")) {
                String[] pair;
                if (!cookie.contains("username")) continue;
                for (String p : pair = cookie.split("\\s*;\\s*")) {
                    if (!p.startsWith("username") || p.indexOf(61) <= 0) continue;
                    return this.decode(p.substring(p.indexOf(61) + 1));
                }
            }
        }
        return NIL;
    }

    private void traceRequest(HttpRequest req, HttpContext context, boolean trace) {
        if (this.logger.isDebugEnabled() && !trace || this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("+").append(this.getForensicId(context));
            sb.append("|").append(req.getRequestLine().toString().replace('|', '_'));
            for (Header hd : req.getAllHeaders()) {
                sb.append("|").append(hd.getName().replace('|', '_'));
                sb.append(":").append(hd.getValue().replace('|', '_'));
            }
            if (trace) {
                this.logger.trace(sb.toString());
            } else {
                this.logger.debug(sb.toString());
            }
        }
    }

    private String getForensicId(HttpContext context) {
        String id = (String)context.getAttribute(FORENSIC_ATTR);
        if (id == null) {
            id = this.uid + this.seq.getAndIncrement();
            context.setAttribute(FORENSIC_ATTR, (Object)id);
        }
        return id;
    }

    private void traceResponse(HttpRequest req, HttpContext context, HttpResponse resp, boolean trace) {
        if (this.logger.isDebugEnabled() && !trace || this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append('-').append(this.getForensicId(context));
            sb.append('|').append(resp.getStatusLine().toString().replace('|', '_'));
            for (Header hd : resp.getAllHeaders()) {
                sb.append('|').append(hd.getName().replace('|', '_'));
                sb.append(':').append(hd.getValue().replace('|', '_'));
            }
            if (trace) {
                this.logger.trace(sb.toString());
            } else {
                this.logger.debug(sb.toString());
            }
        }
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String getClientAddress(HttpContext context) {
        InetAddress remoteAddress;
        if (context == null) {
            return null;
        }
        HttpConnection con = HttpCoreContext.adapt((HttpContext)context).getConnection();
        if (con instanceof HttpInetConnection && (remoteAddress = ((HttpInetConnection)con).getRemoteAddress()) != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }
}

