/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.AutoClosingAsyncClient;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.openrdf.http.object.util.HTTPDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheHandler
implements AsyncExecChain {
    private final Logger logger = LoggerFactory.getLogger(CacheHandler.class);
    private final HTTPDateFormat modifiedformat = new HTTPDateFormat();
    private final AsyncExecChain delegate;
    private final ResourceFactory resourceFactory;
    private final CacheConfig config;
    private final Map<HttpHost, HttpAsyncClient> clients = new HashMap<HttpHost, HttpAsyncClient>();

    public CacheHandler(AsyncExecChain delegate, ResourceFactory resourceFactory, CacheConfig config) {
        assert (delegate != null);
        assert (resourceFactory != null);
        assert (config != null);
        this.delegate = delegate;
        this.resourceFactory = resourceFactory;
        this.config = config;
    }

    public synchronized void reset() {
        this.clients.clear();
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        if (this.config.isHeuristicCachingEnabled()) {
            return this.getClient(target).execute(target, request, context, (FutureCallback)new ResponseCallback(callback){

                @Override
                public void completed(HttpResponse result) {
                    CacheHandler.this.setCacheControlIfCacheable(request, result, context);
                    super.completed(result);
                }
            });
        }
        return this.getClient(target).execute(target, request, context, callback);
    }

    private synchronized HttpAsyncClient getClient(HttpHost target) {
        if (this.clients.containsKey(target)) {
            return this.clients.get(target);
        }
        this.logger.debug("Initializing server side cache for {}", (Object)target);
        ManagedHttpCacheStorage storage = new ManagedHttpCacheStorage(this.config);
        DelegatingClient backend = new DelegatingClient(this.delegate);
        CachingHttpAsyncClient cachingClient = new CachingHttpAsyncClient((HttpAsyncClient)backend, this.resourceFactory, (HttpCacheStorage)storage, this.config);
        AutoClosingAsyncClient client = new AutoClosingAsyncClient((HttpAsyncClient)backend, cachingClient, storage);
        this.clients.put(target, (HttpAsyncClient)client);
        return client;
    }

    void setCacheControlIfCacheable(HttpRequest request, HttpResponse response, HttpContext context) {
        String method = request.getRequestLine().getMethod();
        int sc = response.getStatusLine().getStatusCode();
        if ("GET".equals(method) || "HEAD".equals(method)) {
            switch (sc) {
                case 200: 
                case 203: 
                case 206: 
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 307: 
                case 308: 
                case 410: {
                    this.setCacheControl(response, context);
                }
                case 304: {
                    if (response.getFirstHeader("Cache-Control") == null) break;
                    this.setCacheControl(response, context);
                }
            }
        }
    }

    private void setCacheControl(HttpResponse response, HttpContext context) {
        String cc;
        long now = ObjectContext.adapt(context).getReceivedOn();
        Header lastMod = response.getLastHeader("Last-Modified");
        Header[] headers = response.getHeaders("Cache-Control");
        if (headers != null && headers.length > 0 && now > 0L && lastMod != null && (cc = this.getCacheControl(headers, lastMod, now)) != null) {
            response.removeHeaders("Cache-Control");
            response.setHeader("Cache-Control", cc);
        }
    }

    private String getCacheControl(Header[] cache, Header lastMod, long now) {
        int maxage;
        StringBuilder sb = new StringBuilder();
        for (Header hd : cache) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(hd.getValue());
        }
        if ((sb.length() == 0 || sb.indexOf("max-age") < 0 && sb.indexOf("s-maxage") < 0 && sb.indexOf("no-cache") < 0 && sb.indexOf("no-store") < 0) && (maxage = this.getMaxAgeHeuristic(lastMod, now)) > 0) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("max-age=").append(maxage);
            return sb.toString();
        }
        return null;
    }

    private int getMaxAgeHeuristic(Header lastModified, long now) {
        long lm = this.lastModified(lastModified);
        int fraction = (int)((now - lm) / 10000L);
        return Math.min(fraction, 86400);
    }

    private long lastModified(Header lastModified) {
        return this.modifiedformat.parseHeader(lastModified);
    }

    private final class DelegatingClient
    extends CloseableHttpAsyncClient {
        private final AsyncExecChain delegate;
        private boolean running;

        public DelegatingClient(AsyncExecChain delegate) {
            this.delegate = delegate;
        }

        public void start() {
            this.running = true;
        }

        public void close() {
            this.shutdown();
        }

        public void shutdown() {
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        public IOReactorStatus getStatus() {
            return null;
        }

        public HttpParams getParams() {
            return null;
        }

        public ClientAsyncConnectionManager getConnectionManager() {
            return null;
        }

        public <T> Future<T> execute(HttpAsyncRequestProducer arg0, HttpAsyncResponseConsumer<T> arg1, HttpContext arg2, FutureCallback<T> arg3) {
            throw new UnsupportedOperationException("CachingHttpAsyncClient does not caching for streaming HTTP exchanges");
        }

        public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
            return this.delegate.execute(target, request, context, callback);
        }
    }
}

