/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResourceTarget;
import org.openrdf.http.object.helpers.ResponseCallback;

public class ContentHeadersFilter
implements AsyncExecChain {
    private static final Set<String> contentHeaders = new HashSet<String>(Arrays.asList("age", "cache-control", "content-encoding", "content-language", "content-length", "content-md5", "content-disposition", "content-range", "content-type", "transfer-encoding", "expires", "location", "pragma", "refresh"));
    private final AsyncExecChain delegate;

    public ContentHeadersFilter(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        final ObjectContext ctx = ObjectContext.adapt(context);
        final Request req = new Request(request, ctx);
        return this.delegate.execute(target, request, context, new ResponseCallback(callback){

            @Override
            public void completed(HttpResponse result) {
                try {
                    Object head = ctx.getDerivedFromHeadResponse();
                    HttpRequest oreq = ctx.getOriginalRequest();
                    ResourceTarget resource = ctx.getResourceTarget();
                    if (head == null && oreq != null && resource.getHandlerMethod((HttpRequest)req) != null) {
                        head = resource.head(oreq);
                    }
                    ContentHeadersFilter.this.addHeaders(req, context, (HttpResponse)head, result);
                    super.completed(result);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
                catch (IOException ex) {
                    super.failed(ex);
                }
                catch (HttpException ex) {
                    super.failed((Exception)((Object)ex));
                }
            }
        });
    }

    void addHeaders(Request req, HttpContext context, HttpResponse head, HttpResponse rb) {
        HttpEntity entity;
        if (head != null) {
            Header derivedFrom = head.getFirstHeader("Content-Version");
            Header version = rb.getFirstHeader("Content-Version");
            if (version != null && derivedFrom != null && !version.getValue().equals(derivedFrom.getValue())) {
                for (Header hd : head.getHeaders("Content-Version")) {
                    rb.addHeader("Derived-From", hd.getValue());
                }
            }
            int code = rb.getStatusLine().getStatusCode();
            for (Header hd : head.getAllHeaders()) {
                boolean safe;
                String name = hd.getName();
                boolean bl = safe = "GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod());
                if ((!safe || code >= 400 || code == 304) && contentHeaders.contains(name.toLowerCase())) continue;
                this.addIfAbsent(name, head, rb);
            }
        }
        if ((entity = rb.getEntity()) != null) {
            if (!rb.containsHeader("Content-Encoding") && entity.getContentEncoding() != null) {
                rb.setHeader(entity.getContentEncoding());
            }
            if (!rb.containsHeader("Content-Type") && entity.getContentType() != null) {
                rb.setHeader(entity.getContentType());
            }
            if (!rb.containsHeader("Content-Length") && entity.getContentLength() >= 0L) {
                rb.setHeader("Content-Length", Long.toString(entity.getContentLength()));
            }
        }
    }

    private void addIfAbsent(String name, HttpResponse head, HttpResponse rb) {
        if (!rb.containsHeader(name) && head.containsHeader(name)) {
            for (Header hd : head.getHeaders(name)) {
                rb.addHeader(hd);
            }
        }
    }
}

