/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.impl.execchain.ClientExecChain;
import org.openrdf.http.object.io.LatencyInputStream;

public class ContentPeekHandler
implements ClientExecChain {
    private static final int MIN_RESPONSE_SIZE = 65536;
    private final int size;
    private final ClientExecChain delegate;

    public ContentPeekHandler(ClientExecChain delegate) {
        this(delegate, 65536);
    }

    public ContentPeekHandler(ClientExecChain delegate, int size) {
        this.delegate = delegate;
        this.size = size;
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        long read;
        CloseableHttpResponse resp = this.delegate.execute(route, request, clientContext, execAware);
        HttpEntity entity = resp.getEntity();
        if (entity == null) {
            return resp;
        }
        LatencyInputStream in = new LatencyInputStream(entity.getContent(), this.size);
        in.mark(this.size);
        int count = 0;
        while ((count = (int)((long)count + (read = in.skip(this.size - count)))) < this.size && read > 0L) {
        }
        in.reset();
        BasicHttpEntity e = new BasicHttpEntity();
        e.setContentType(entity.getContentType());
        e.setContentEncoding(entity.getContentEncoding());
        e.setContent((InputStream)in);
        if (read <= 0L) {
            e.setChunked(false);
            e.setContentLength((long)count);
        } else {
            e.setChunked(entity.isChunked());
            e.setContentLength(entity.getContentLength());
        }
        resp.setEntity((HttpEntity)e);
        return resp;
    }
}

