/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.helpers.ChainedFutureCallback;
import org.openrdf.http.object.helpers.ObjectContext;
import org.openrdf.http.object.helpers.ResponseCallback;

public class DerivedFromHeadFilter
implements AsyncExecChain {
    private static final Set<String> contentHeaders = new HashSet<String>(Arrays.asList("age", "cache-control", "content-encoding", "content-language", "content-length", "content-md5", "content-disposition", "content-range", "content-type", "transfer-encoding", "expires", "location", "pragma", "refresh"));
    final AsyncExecChain delegate;

    public DerivedFromHeadFilter(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(final HttpHost target, final HttpRequest request, final HttpContext context, FutureCallback<HttpResponse> callback) {
        if ("HEAD".equals(request.getRequestLine().getMethod())) {
            return this.delegate.execute(target, request, context, callback);
        }
        HttpRequest head = this.asHeadRequest(request);
        final ObjectContext ctx = ObjectContext.adapt(context);
        BasicFuture future = new BasicFuture(callback);
        final ChainedFutureCallback chained = new ChainedFutureCallback((BasicFuture<HttpResponse>)future);
        ctx.setOriginalRequest(request);
        this.delegate.execute(target, head, context, new ResponseCallback(chained){

            @Override
            public void completed(HttpResponse headResponse) {
                try {
                    ctx.setDerivedFromHeadResponse(headResponse);
                    ctx.setOriginalRequest(null);
                    DerivedFromHeadFilter.this.delegateRequest(target, request, context, chained);
                }
                catch (RuntimeException ex) {
                    this.failed(ex);
                }
            }

            @Override
            public void failed(Exception ex) {
                ctx.setOriginalRequest(null);
                super.failed(ex);
            }

            @Override
            public void cancelled() {
                ctx.setOriginalRequest(null);
                super.cancelled();
            }
        });
        return future;
    }

    Future<HttpResponse> delegateRequest(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        final ObjectContext ctx = ObjectContext.adapt(context);
        return this.delegate.execute(target, request, context, new ResponseCallback(callback){

            @Override
            public void completed(HttpResponse rb) {
                try {
                    ctx.setDerivedFromHeadResponse(null);
                    super.completed(rb);
                }
                catch (RuntimeException ex) {
                    this.failed(ex);
                }
            }

            @Override
            public void failed(Exception ex) {
                ctx.setDerivedFromHeadResponse(null);
                super.failed(ex);
            }

            @Override
            public void cancelled() {
                ctx.setDerivedFromHeadResponse(null);
                super.cancelled();
            }
        });
    }

    private HttpRequest asHeadRequest(HttpRequest request) {
        RequestLine line = request.getRequestLine();
        ProtocolVersion ver = line.getProtocolVersion();
        BasicHttpRequest head = new BasicHttpRequest("HEAD", line.getUri(), ver);
        for (Header header : request.getAllHeaders()) {
            if (contentHeaders.contains(header.getName().toLowerCase())) continue;
            head.addHeader(header);
        }
        if ("PUT".equals(line.getMethod()) && request.containsHeader("Content-Type")) {
            head.setHeader("Accept", request.getFirstHeader("Content-Type").getValue());
        }
        return head;
    }
}

