/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.CloseableEntity;
import org.openrdf.http.object.client.GUnzipEntity;
import org.openrdf.http.object.client.GZipEntity;
import org.openrdf.http.object.helpers.EditableHttpEntityEnclosingRequest;
import org.openrdf.http.object.helpers.Request;
import org.openrdf.http.object.helpers.ResponseCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUnzipFilter
implements AsyncExecChain {
    private static final BasicStatusLine STATUS_203 = new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, 203, "Non-Authoritative Information");
    private final String hostname = this.getLocalHostName();
    private final String WARN_214 = "214 " + this.hostname + " \"Transformation applied\"";
    private final Logger logger = LoggerFactory.getLogger(GUnzipFilter.class);
    private final AsyncExecChain delegate;

    public GUnzipFilter(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        Object req;
        HttpEntity entity;
        Header hd = request.getFirstHeader("Content-Encoding");
        if (hd != null && "gzip".equals(hd.getValue()) && (entity = ((EditableHttpEntityEnclosingRequest)(req = new Request((HttpRequest)request, context))).getEntity()) != null) {
            ((EditableHttpEntityEnclosingRequest)req).removeHeaders("Content-Length");
            ((EditableHttpEntityEnclosingRequest)req).setHeader("Content-Encoding", "identity");
            ((EditableHttpEntityEnclosingRequest)req).setHeader("Transfer-Encoding", "chunked");
            ((EditableHttpEntityEnclosingRequest)req).addHeader("Warning", this.WARN_214);
            ((EditableHttpEntityEnclosingRequest)req).setEntity(this.gunzip(entity));
            request = req;
        }
        req = request;
        return this.delegate.execute(target, (HttpRequest)request, context, new ResponseCallback(callback, (HttpRequest)req, context){
            final /* synthetic */ HttpRequest val$req;
            final /* synthetic */ HttpContext val$context;
            {
                this.val$req = httpRequest;
                this.val$context = httpContext;
                super((FutureCallback<HttpResponse>)delegate);
            }

            @Override
            public void completed(HttpResponse result) {
                try {
                    GUnzipFilter.this.filter(this.val$req, this.val$context, result);
                    super.completed(result);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
            }
        });
    }

    void filter(HttpRequest req, HttpContext context, HttpResponse resp) {
        HttpEntity entity;
        Header cache = resp.getFirstHeader("Cache-Control");
        if (cache != null && cache.getValue().contains("no-transform")) {
            return;
        }
        Boolean gzip = null;
        boolean encode = false;
        for (Header header : req.getHeaders("Accept-Encoding")) {
            for (String value : header.getValue().split("\\s*,\\s*")) {
                String[] items = value.split("\\s*;\\s*");
                double q = 1.0;
                try {
                    for (int i = 1; i < items.length; ++i) {
                        if (!items[i].startsWith("q=")) continue;
                        q = Double.parseDouble(items[i].substring(2));
                    }
                }
                catch (NumberFormatException e) {
                    this.logger.warn(e.toString(), (Throwable)e);
                }
                if ("gzip".equals(items[0])) {
                    gzip = q > 0.0;
                    continue;
                }
                if (!"*".equals(items[0])) continue;
                encode = q > 0.0;
            }
        }
        if (gzip == null ? encode : gzip != false) {
            return;
        }
        Header encoding = resp.getFirstHeader("Content-Encoding");
        if (encoding != null && "gzip".equals(encoding.getValue()) && (entity = resp.getEntity()) != null) {
            resp.removeHeaders("Content-MD5");
            resp.removeHeaders("Content-Length");
            resp.setHeader("Content-Encoding", "identity");
            resp.setHeader("Transfer-Encoding", "chunked");
            if (resp.getStatusLine().getStatusCode() == 200) {
                resp.setStatusLine((StatusLine)STATUS_203);
            } else {
                resp.addHeader("Warning", this.WARN_214);
            }
            if (entity instanceof GZipEntity) {
                resp.setEntity(((GZipEntity)entity).getEntityDelegate());
            } else {
                resp.setEntity((HttpEntity)new GUnzipEntity(entity));
            }
        }
    }

    private HttpEntity gunzip(HttpEntity entity) {
        if (entity instanceof GZipEntity) {
            return ((GZipEntity)entity).getEntityDelegate();
        }
        if (entity instanceof CloseableEntity) {
            CloseableEntity centity = (CloseableEntity)entity;
            centity.setEntityDelegate(this.gunzip(centity.getEntityDelegate()));
            return centity;
        }
        return new GUnzipEntity(entity);
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName().toLowerCase();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }
}

