/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.object.chain;

import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.protocol.HttpContext;
import org.openrdf.http.object.chain.AsyncExecChain;
import org.openrdf.http.object.client.CloseableEntity;
import org.openrdf.http.object.client.GUnzipEntity;
import org.openrdf.http.object.client.GZipEntity;
import org.openrdf.http.object.helpers.StagedFuture;

public class GZipFilter
implements AsyncExecChain {
    private final AsyncExecChain delegate;

    public GZipFilter(AsyncExecChain delegate) {
        this.delegate = delegate;
    }

    @Override
    public Future<HttpResponse> execute(HttpHost target, HttpRequest request, HttpContext context, FutureCallback<HttpResponse> callback) {
        String method = request.getRequestLine().getMethod();
        if (!method.equals("GET") && !method.equals("HEAD")) {
            return this.delegate.execute(target, request, context, callback);
        }
        StagedFuture future = new StagedFuture(callback){

            @Override
            public void completed(HttpResponse result) {
                try {
                    super.completed(GZipFilter.this.gzip(result));
                }
                catch (IllegalArgumentException ex) {
                    super.failed(ex);
                }
                catch (RuntimeException ex) {
                    super.failed(ex);
                }
            }
        };
        future.addStage(this.delegate.execute(target, request, context, future));
        return future;
    }

    protected HttpResponse gzip(HttpResponse resp) {
        int code = resp.getStatusLine().getStatusCode();
        boolean compressed = this.isAlreadyCompressed(resp.getEntity());
        if (code < 500 && this.isCompressable(resp) || compressed) {
            long len = this.getContentLength(resp);
            if (compressed || len < 0L || len > 500L) {
                resp.removeHeaders("Content-MD5");
                resp.removeHeaders("Content-Length");
                resp.setHeader("Transfer-Encoding", "chunked");
                resp.setHeader("Content-Encoding", "gzip");
                resp.setEntity(this.gzip(resp.getEntity()));
            }
        }
        return resp;
    }

    private boolean isAlreadyCompressed(HttpEntity entity) {
        if (entity instanceof GUnzipEntity) {
            return true;
        }
        if (entity instanceof CloseableEntity) {
            return this.isAlreadyCompressed(((CloseableEntity)entity).getEntityDelegate());
        }
        return false;
    }

    private long getContentLength(HttpResponse resp) {
        if (resp.getEntity() != null) {
            return resp.getEntity().getContentLength();
        }
        Header length = resp.getFirstHeader("Content-Length");
        if (length == null) {
            return -1L;
        }
        return Long.parseLong(length.getValue());
    }

    private HttpEntity gzip(HttpEntity entity) {
        if (entity instanceof GUnzipEntity) {
            return ((GUnzipEntity)entity).getEntityDelegate();
        }
        if (entity instanceof CloseableEntity) {
            CloseableEntity centity = (CloseableEntity)entity;
            centity.setEntityDelegate(this.gzip(centity.getEntityDelegate()));
            return centity;
        }
        return new GZipEntity(entity);
    }

    private boolean isCompressable(HttpResponse msg) {
        if (msg.getEntity() == null) {
            return false;
        }
        Header contentType = msg.getFirstHeader("Content-Type");
        if (contentType == null) {
            contentType = msg.getEntity().getContentType();
        }
        if (contentType == null) {
            return false;
        }
        for (Header hd : msg.getHeaders("Cache-Control")) {
            if (!hd.getValue().contains("no-transform")) continue;
            return false;
        }
        Header encoding = msg.getFirstHeader("Content-Encoding");
        boolean identity = encoding == null || "identity".equals(encoding.getValue());
        String type = contentType.getValue();
        boolean compressable = type.startsWith("text/") || type.startsWith("application/xml") || type.startsWith("application/x-turtle") || type.startsWith("application/sparql-quey") || type.startsWith("application/trix") || type.startsWith("application/x-trig") || type.startsWith("application/postscript") || type.startsWith("application/javascript") || type.startsWith("application/json") || type.startsWith("application/mbox") || type.startsWith("application/") && (type.endsWith("+xml") || type.contains("+xml;"));
        return identity && compressable;
    }
}

